<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
$post_id               = get_the_ID();
$def_settings          = get_option( DESIGN_OPTION_NAME, FULL_SCHEMA_RICH_SNIPPET_SETTINGS::design_def_settings() );
$live_rating_font_size = $def_settings['fsrs_st_down_font_size'];
$rating_data           = FSRS_COMMON::get_post_rating( get_the_ID() );
$rating_fa_value       = FSRS_COMMON::convert_english_to_persian_number( $rating_data['rating'] );
$seen_count_fa_value   = FSRS_COMMON::convert_english_to_persian_number( $rating_data['seen_count'] );

$loading_color         = $def_settings['fsrs_loading_fill_color'] ?? '#6aa8d1';
$rating_title          = $def_settings['fsrs_rating_title'] ?? '';

?>
    <div class="safine-full-schema-container"
         style="display: flex!important;flex-direction: column;
         align-items: flex-start;padding-bottom: 8px;padding-right: 4px;">
        <p class="fsrs-rating-title"><?php esc_html_e( $rating_title,
				'full-schema' ); ?></p>
        <div class="fsrs-star-rating" id="fsrs-rating"
             style="text-align: center!important;display: flex;justify-content: flex-start;align-items: center;">
            <ul class="fsrs-star-rating__wrap" id="fsrs-star-rating__wrap" style="display: inline">
                <li class="fsrs-rating-icons-container"
                    id="fsrs-rating-after-content-emoji-ico"
                    fsrs-data-rating="<?php esc_attr_e( $rating_data['rating'] ); ?>"
                    style="display: inline-flex!important"></li>
            </ul>
            <div class="live-rating fsrs-h4" style="
                    font-size: <?php echo $live_rating_font_size ?>px;
                    margin-top:0!important; margin-bottom: 0!important; margin-inline-start: 8px;"
                 id="fsrs-live-rating">
				        <span class="fsrs-ratings-info"><?php esc_html_e( 'میانگین امتیازات ',
						        'full-schema' ); ?> <strong>
                            <?php echo $rating_fa_value ?>
                            </strong> <?php esc_html_e( ' از' . " " .
				                                        FSRS_COMMON::convert_english_to_persian_number( '5' ),
						        'full-schema' ); ?> </span>
            </div>

	        <?php
	        if ( $def_settings['fsrs_show_number_of_votes'] === '1' ) {
		        ?>
                <div class="fsrs-vertical-line" style="height: 45px;"></div>
                <div class="live-rating live-rating-count fsrs-h4" style="
                        font-size: <?php echo $live_rating_font_size ?>px;
                        margin-top:0!important; margin-bottom: 0!important; margin-inline-start: 8px;"
                     id="fsrs-live-rating-count">
			    	 <span class=fsrs-ratings-info> <?php esc_html_e( 'از مجموع ', 'full-schema' );
					     ?> <strong>
                        <?php echo $seen_count_fa_value ?> </strong> <?php esc_html_e( 'رای',
						     'full-schema' ); ?></span>
                </div>

	        <?php } ?>
        </div>
	    <?php
	    if ( $def_settings['fsrs_show_progress'] === '1' ) {
		    UI::getInstance()->render_spinner_progress( $loading_color, "",
			    "margin-top: 10px!important; margin-inline-start: 8px!important;" );
	    }
	    ?>
        <div style="margin-top: 10px!important; margin-inline-start: 8px!important;">
                <span class="rating-hov-text fsrs-h2" style="font-size:<?php echo $live_rating_font_size ?>px"
                      id="rating-hov-text"></span>
        </div>
        <input type="hidden" id="post-id" value="<?php esc_attr_e($post_id); ?>">
    </div>
<?php

