<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class FSRS_DEFAULT_RATING_TEMP {
	public function __construct( $design_options ) {
		$post_id               = get_the_ID();
		$live_rating_font_size = $design_options['fsrs_st_down_font_size'] ?? 18;
		$rating_data           = FSRS_COMMON::get_post_rating( get_the_ID() );
		$rating_fa_value       = FSRS_COMMON::convert_english_to_persian_number( $rating_data['rating'] );
		$seen_count_fa_value   = FSRS_COMMON::convert_english_to_persian_number( $rating_data['seen_count'] );
		$loading_color         = $design_options['fsrs_loading_fill_color'] ?? '#6aa8d1';
		$rating_title          = $design_options['fsrs_rating_title'] ?? '';

		?>
        <div class="safine-full-schema-container">
            <p class="fsrs-rating-title" style="text-align: center"><?php esc_html_e( $rating_title,
					'full-schema' ); ?></p>
            <div class="fsrs-star-rating" id="fsrs-rating">
                <ul class="fsrs-star-rating__wrap" id="fsrs-star-rating__wrap">
                    <li class="fsrs-rating-icons-container"
                        id="fsrs-rating-after-content" fsrs-data-rating="<?php esc_attr_e( $rating_data['rating'] ); ?>"
                        style="display: inline-flex;"></li>
                </ul>
            </div>
            <div style="text-align: center; margin-top: 10px;">
            <span class="rating-hov-text fsrs-h2" style="font-size:<?php echo $live_rating_font_size ?>px"
                  id="rating-hov-text"></span></div>
			<?php
			if ( $design_options['fsrs_show_progress'] === '1' ) {
				UI::getInstance()->render_spinner_progress( $loading_color, 'center', "" );
			}
			?>
        <div class="live-rating fsrs-h4" style="
                font-size: <?php echo $live_rating_font_size ?>px" id="fsrs-live-rating">
				        <span class="fsrs-ratings-info"><?php esc_html_e( 'میانگین امتیازات ',
						        'full-schema' ); ?> <strong>
                            <?php echo $rating_fa_value ?>
                            </strong> <?php esc_html_e( ' از' . ' ' .
                                                        FSRS_COMMON::convert_english_to_persian_number('5'),
                                'full-schema' ); ?> </span>
        </div>
        <input type="hidden" id="post-id" value="<?php echo $post_id ?>">
		<?php
		if ( $design_options['fsrs_show_number_of_votes'] === '1' ) {
			?>
            <div class="live-rating live-rating-count fsrs-h4" style="
                    font-size: <?php echo $live_rating_font_size ?>px" id="fsrs-live-rating-count">
			    	 <span class=fsrs-ratings-info> <?php esc_html_e( 'از مجموع ', 'full-schema' );
					     ?> <strong>
                        <?php echo $seen_count_fa_value ?> </strong> <?php esc_html_e( 'رای',
						     'full-schema' ); ?></span>
                </div>

			<?php } ?>
        </div>
		<?php
	}
}


