<?php

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

$options               = get_option( 'fsrs_def_settings', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::design_def_settings() );
$top_star_size         = $options['fsrs_st_up_star_size'];
$down_star_size        = $options['fsrs_st_down_star_size'];
$live_rating_font_size = $options['fsrs_st_down_font_size'];
$down_star_bg_color    = $options['fsrs_st_down_bg_color'] ?? '#ffffff';
$border_color          = $options['fsrs_st_down_border_color'] ?? '#e2e1e1';
$frame_bg_color        = $options['fsrs_st_down_frame_bg_color'] ?? '#ffffff';
$texts_color           = $options['fsrs_st_down_texts_color'] ?? '#000000';
$normal_color          = $options['fsrs_normal_color'] ?? '#ffeaa8';
$rated_color           = $options['fsrs_rated_color'] ?? '#FFD700';
$hover_color           = $options['fsrs_hover_color'] ?? '#fdd835';
$star_shape            = $options['fsrs_star_shape'] ?? 'rounded';
$star_direction        = $options['fsrs_star_direction'] ?? 'ltr';
//hover text options
$hover_font_size    = $options['fsrs_hover_text_font_size'] ?? '14';
$hover_font_color   = $options['fsrs_hover_text_font_color'] ?? '#000000CC';
$hover_bg_color     = $options['fsrs_hover_text_bg_color'] ?? '#FFFFFF';
$hover_border_color = $options['fsrs_hover_text_border_color'] ?? '#BFBFBF';
//title options
$title_color     = $options['fsrs_rating_title_color'] ?? '#2c2d2e';
$title_font_size = $options['fsrs_rating_title_font_size'] ?? 16;

if ( $star_direction === 'ltr' ) {
	$star_direction_content = 'rtl';
} else {
	$star_direction_content = 'ltr';
}
if ( $star_shape === 'rounded' ) {
	$star_shape_content = '\e900';
} else {
	$star_shape_content = '\e9d9';
}
?>
<style>
    #fsrs-rating-before-content > .fsrs-rating-icon {
        font-size: <?php esc_attr_e( $top_star_size ); ?>px !important;
    }

    #fsrs-rating-after-content > .fsrs-rating-icon, #fsrs-rating-after-content > .fsrs-rating-icon--clicked,
    #fsrs-rating-after-content > .fsrs-rating-icon--disabled, .fsrs-rating-emoji-icon,
    #fsrs-rating-after-content-emoji-ico > .fsrs-rating-icon--disabled {
        font-size: <?php esc_attr_e( $down_star_size ); ?>px !important;
        background: <?php esc_attr_e( $down_star_bg_color ); ?>;
        border-radius: 20px;
        padding: 4px 3px 5px;
    }

    .safine-full-schema-container {
        background: <?php esc_attr_e( $frame_bg_color ); ?>;
        border: 1px solid<?php esc_attr_e( $border_color ); ?>;
        padding-top: 12px;
        color: <?php esc_attr_e( $texts_color ); ?>
    }

    .fsrs-rating-icons-container > .checked ~ i, .fsrs-rating-icons-container > .checked {
        color: <?php esc_attr_e( $normal_color ); ?>;
    }

    #fsrs-rating-after-content > .fsrs-rating-icon--clicked ~ i, .fsrs-rating-icon--clicked {
        color: <?php esc_attr_e( $rated_color ); ?> !important;
    }

    @media (hover: hover) {
        #fsrs-rating-after-content > .fsrs-rating-icon:hover, .fsrs-rating-emoji-icon:hover {
            color: <?php esc_attr_e( $hover_color ); ?> !important;
            transition: transform .1s ease-in-out;
            transition-property: transform;
            transition-duration: 0.1s;
            transition-timing-function: ease-in-out;
            transition-delay: 0s;
            transform: translateY(-10%);
        }

    }

    .fsrs-rating-icons-container > .selected ~ i {
        color: <?php esc_attr_e( $hover_color ); ?> !important;

    }

    .fsrs-rating-icon:before, .fsrs-rating-icon--clicked:before, .fsrs-rating-icon--disabled:before {
        content: "<?php esc_attr_e( $star_shape_content ); ?>";
    }

    .fsrs-star-rating__wrap, .fsrs-rating-top > .readonly {
        direction: <?php esc_attr_e( $star_direction_content ); ?>
    }

    .fsrs-star-hover-txt {
        font-family: fsrs_vazir;
        display: none;
        position: absolute;
        top: -33px;
        left: 50%;
        margin-left: 0 !important;
        background-color: <?php esc_attr_e($hover_bg_color); ?>;
        color: <?php esc_attr_e($hover_font_color); ?>;
        width: auto !important;
        min-width: 45px;
        border: 1px solid<?php esc_attr_e($hover_border_color); ?>;
        border-radius: 4px;
        padding: 4px 5px 4px 5px;
        font-size: <?php esc_attr_e($hover_font_size); ?>px;
        text-align: center;
        white-space: nowrap;
        transform: translateX(-50%);
    }

    .fsrs-rating-title {
        font-size: <?php esc_attr_e($title_font_size);?>px !important;
        color: <?php esc_attr_e($title_color); ?>;
    }

    .fsrs-avg-ratings {
        font-size: <?php esc_attr_e($live_rating_font_size); ?>px!important;
    }

    @media only screen and (max-width: 48em) {
        .fsrs-min-width-star-hover-text {
            color: <?php esc_attr_e($texts_color); ?>;
        }
    }
</style>

