<?php

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * Core class
 *
 * Class FULL_SCHEMA
 */
final class FULL_SCHEMA {
	private static $instance;

	protected $loader;

	protected $fsrs;

	public function __construct() {
		$this->fsrs = 'full-schema';
		$this->load_files();
		$this->set_locale();
		ini_set( 'display_errors', 0 );
		error_reporting( 0 );
	}

	/**
	 * Load all dependencies
	 */
	private function load_files() {
		require_once FSRS_COMMON_DIR . 'FULL_SCHEMA_RICH_SNIPPET_SETTINGS.php';
		require_once FSRS_COMMON_DIR . 'FSRS_COMMON.php';
		require_once FSRS_INC_DIR . 'FSRS_LOADER.php';
		require_once FSRS_INC_DIR . 'FULL_SCHEMA_i18n.php';
		require_once FSRS_INC_DIR . 'FSRS_REQUESTS.php';
		require_once FSRS_PUB_DIR . 'template/FSRS_DEFAULT_RATING_TEMP.php';
		require_once FSRS_PUB_DIR . 'FSRS_PUBLIC_INIT.php';
		require_once FSRS_ADMIN_DIR . 'FSRS_ADMIN_INIT.php';
		require_once FSRS_ADMIN_DIR . 'template/FSRS_ACTIVATION.php';
		require_once FSRS_ADMIN_DIR . 'template/fsrs-mail-temp.php';
		require_once FSRS_ADMIN_DIR . 'UI.php';
		require_once FSRS_ADMIN_DIR . 'TABS.php';
		require_once FSRS_ADMIN_DIR . 'FSRS_TAB_DASHBOARD.php';
		require_once FSRS_ADMIN_DIR . 'FSRS_TAB_ACTIVATION.php';
		require_once FSRS_ADMIN_DIR . 'FSRS_TAB_UPDATES.php';
		require_once FSRS_ADMIN_DIR . 'FSRS_TAB_DESIGN.php';
		require_once FSRS_ADMIN_DIR . 'FSRS_TAB_STARS_TEXT.php';
		require_once FSRS_ADMIN_DIR . 'FSRS_TAB_TOOLS.php';
		require_once FSRS_ADMIN_DIR . 'FSRS_TAB_MARKETING.php';

		$this->loader = new FSRS_LOADER();
		$this->define_admin_hooks();
		$this->define_public_hooks();
	}

	private function define_admin_hooks() {
		$fsrs_admin = new FSRS_ADMIN_INIT();
		$this->loader->add_action( 'admin_enqueue_scripts', $fsrs_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $fsrs_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'admin_notices', $fsrs_admin, 'sample_admin_notice__success' );
		$this->loader->add_filter( "plugin_action_links", $fsrs_admin, 'add_setting_link', 10, 2 );
		$this->loader->add_action( 'add_meta_boxes', $fsrs_admin, 'fsrs_add_custom_box' );
		$this->loader->add_action( 'admin_menu', $fsrs_admin, 'fsrsMenuPage' );
		$this->loader->add_action( 'fsrs_daily_check_promotion', $fsrs_admin, 'fsrs_daily_check_promotion_callback' );
		//taxonomy meta box
		$this->loader->add_action( 'product_cat_add_form_fields', $fsrs_admin, 'tax_meta' );
		$this->loader->add_action( 'product_tag_add_form_fields', $fsrs_admin, 'tax_meta' );
		$this->loader->add_action( 'product_cat_edit_form_fields', $fsrs_admin, 'tax_meta_edit' );
		$this->loader->add_action( 'product_tag_edit_form_fields', $fsrs_admin, 'tax_meta_edit' );
		$this->loader->add_action( 'edit_' . 'product_cat', $fsrs_admin, 'save_tax_meta' );
		$this->loader->add_action( 'create_' . 'product_cat', $fsrs_admin, 'save_tax_meta' );
		$this->loader->add_action( 'edit_' . 'product_tag', $fsrs_admin, 'save_tax_meta' );
		$this->loader->add_action( 'create_' . 'product_tag', $fsrs_admin, 'save_tax_meta' );

		$taxonomies = get_taxonomies( [ 'publicly_queryable' => true ] );
		$taxonomies = array_keys( $taxonomies );
		foreach ( $taxonomies as $taxonomy ) {
			$this->loader->add_action( $taxonomy . '_add_form_fields', $fsrs_admin, 'tax_meta', 10, 2 );
			$this->loader->add_action( $taxonomy . '_edit_form_fields', $fsrs_admin, 'tax_meta_edit', 10, 2 );

			$this->loader->add_action( 'edit_' . $taxonomy, $fsrs_admin, 'save_tax_meta' );
			$this->loader->add_action( 'create_' . $taxonomy, $fsrs_admin, 'save_tax_meta' );
		}
		$this->loader->add_action( 'save_post', $fsrs_admin, 'save' );
	}

	private function define_public_hooks() {
		$fsrs_public = new FSRS_PUBLIC_INIT( $this->fsrs );
		$valid       = get_option( 'fsrs_pr_option' );
		if ( ! empty( $valid ) && $valid['valid'] === '1' ) {
			$this->loader->add_action( 'wp_enqueue_scripts', $fsrs_public, 'enqueue_styles' );
			$this->loader->add_action( 'wp_enqueue_scripts', $fsrs_public, 'enqueue_scripts' );
			$this->loader->add_action( 'wp_head', $fsrs_public, 'print_rating_schema' );
			$this->loader->add_action( 'wp_head', $fsrs_public, 'add_header_script' );
			$this->loader->add_action( 'wp_footer', $fsrs_public, 'add_footer_script' );
			$this->loader->add_action( 'wp_footer', $fsrs_public, 'print_faq_schema' );
		}
		$this->loader->add_filter( 'the_content', $fsrs_public, 'fsrs_rating_show_in_content' );
	}

	public function run() {
		$this->loader->run();
	}

	private function set_locale() {
		$plugin_i18n = new FULL_SCHEMA_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );
	}

	public function getFsrs(): string {
		return $this->fsrs;
	}

	public function get_loader() {
		return $this->loader;
	}

	public static function get_instance(): FULL_SCHEMA {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}
}