<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class FSRS_ACTIVATOR {
	public static function activate() {
		if (get_option('license_key') === false) {
			$license_key = '';
			add_option( 'license_key', $license_key );
		}
		if (get_option(MARKETING_OPTION_NAME) === false) {
			add_option(MARKETING_OPTION_NAME, FULL_SCHEMA_RICH_SNIPPET_SETTINGS::marketing_def_settings());
		}
		if (get_option(DESIGN_OPTION_NAME) === false) {
			add_option(DESIGN_OPTION_NAME, FULL_SCHEMA_RICH_SNIPPET_SETTINGS::design_def_settings());
		}
		if (get_option('fsrs_star_texts') === false) {
			add_option('fsrs_star_texts', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::star_texts());
		}
		if ( ! wp_next_scheduled( 'fsrs_daily_check_promotion' ) ) {
			wp_schedule_event( time(), 'twicedaily', 'fsrs_daily_check_promotion' );
		}
		if ( ! wp_next_scheduled( 'fsrs_daily_check_validity' ) ) {
			wp_schedule_event( time(), 'daily', 'fsrs_daily_check_validity' );
		}

	}

	public function clear_cache() {
		// Load WordPress.
		require( 'wp-load.php' );

		if ( function_exists( 'rocket_clean_domain' ) ) {
			rocket_clean_domain();
		}

		if ( function_exists( 'run_rocket_sitemap_preload' ) ) {
			run_rocket_sitemap_preload();
		}

	}

}
