<?php

/**
 *
 * @encoding        UTF-8
 * @version         1.4.0
 * @copyright       (C) 2020 - 2021 Mahdi Mohammadi ( https://safine.net/ ). All rights reserved.
 * @license         Zhaket guard license
 * @contributors    Mohammad Hossein Mohammadi (onyx133@topio.ir)
 * @support         support@safine.net
 *
 * @wordpress-plugin
 * Plugin Name: فول اسکیما ریچ اسنیپت
 * Plugin URI: https://safine.net
 * Description: افزونه قدرتمند و کاملا ایرانی برای نشانه دار شدن صفحات سایت در نتایج جستجو با ستاره و سوال و جواب. به همراه امکان تزریق کد دلخواه به هدر و فوتر صفحات
 * Version: 1.4.0
 * Requires PHP: 7.0
 * Tested up to: 5.7.2
 * Author: آکادمی سفینه (مهدی محمدی)
 * Author URI: https://safine.net
 * Text Domain:       full-schema
 * Domain Path:       /languages
 *
 */

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

// Plugin version
const FULL_SCHEMA_RICH_SNIPPET_VERSION = '1.4.0';

//Plugin options name
const DESIGN_OPTION_NAME    = 'fsrs_def_settings';
const MARKETING_OPTION_NAME = 'fsrs_marketing_setting';

//define necessary directories path
define( 'FSRS_DIR', plugin_dir_path( __FILE__ ) );
define( 'FSRS_URL', plugin_dir_url( __FILE__ ) );
define( 'FSRS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'FSRS_INC_DIR', trailingslashit( FSRS_DIR . 'includes' ) );
define( 'FSRS_PUB_DIR', trailingslashit( FSRS_DIR . 'public' ) );
define( 'FSRS_ADMIN_DIR', trailingslashit( FSRS_DIR . 'admin' ) );
define( 'FSRS_ADMIN_URL', trailingslashit( FSRS_URL . 'admin' ) );
define( 'FSRS_COMMON_DIR', trailingslashit( FSRS_DIR . 'common' ) );
define( 'FSRS_ASSETS_DIR', trailingslashit( FSRS_URL . 'public/assets' ) );
define( 'FSRS_JS_DIR', trailingslashit( FSRS_ASSETS_DIR . 'js' ) );
define( 'FSRS_IMAGES_DIR', trailingslashit( FSRS_ASSETS_DIR . 'images' ) );
define( 'FSRS_CSS_DIR', trailingslashit( FSRS_ASSETS_DIR . 'css' ) );

//register activate hook
register_activation_hook( __FILE__, 'fsrs_activation_hook' );

//register activate hook
register_deactivation_hook( __FILE__, 'fsrs_deactivation_hook' );

//register activation function
function fsrs_activation_hook() {
	require_once FSRS_INC_DIR . 'FSRS_ACTIVATOR.php';
	FSRS_ACTIVATOR::activate();
}

//register de-activation function
function fsrs_deactivation_hook() {
	require_once FSRS_INC_DIR . 'FSRS_DEACTIVATOR.php';
	FSRS_DEACTIVATOR::de_activate();
}

//core plugin class
require FSRS_INC_DIR . 'FULL_SCHEMA.php';

//run and execute fsrs function
function execute_fsrs() {
	FULL_SCHEMA::get_instance()->run();
}

execute_fsrs();

