<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
?>
    <input type="hidden" name="fsrs-schema-nonce"
           value="<?php echo esc_attr( wp_create_nonce( 'fsrs-rating-schema' ) ); ?>">
    <div class="fsrs-rating-header" onclick="hideParentChild('fsrs-rate-option-container')">
        <h3>
                    <span class="dashicons dashicons-star-filled"
                          style="font-size: 24px; color: #ffba00; margin-left: 4px; margin-top: -3px"></span>
            <span><?php esc_html_e('اسکیما ریتینگ (ستاره دار شدن)', 'full-schema');?></span>
        </h3>
    </div>
    <div class="fsrs-rate-option-container" id="fsrs-rate-option-container">
    <div class="fsrs-rating-item">
		<?php
		if ( $post_type !== 'post' ) {
			if ( $page_rating_show_option['showOption'] === '1' ) {
				echo '
                    <div class="fsrs-rating-show-option-container">
                        <p style="margin-right: 12px">
                             <label for="fsrs-rating-show-option" class="fsrs-h4">'.__(
                                     ' آیا میخواهید این صفحه ستاره دار شود؟', 'full-schema').'
                            <input type="checkbox" value="1" id="fsrs-rating-show-option" checked="checked"
 						    name="fsrs-rating-show-option" class="checkbox" style="margin-right: 8px;
 						    margin-top: -1px"></label></p></div>';
			} else {
				echo '<div class="fsrs-rating-show-option-container">
                                    <p> 
                                        <label for="fsrs-rating-show-option">'. __(
                                                ' آیا میخواهید این صفحه ستاره دار شود؟',
                                                'full-schema').'
                                        <input type="checkbox" value="1" id="fsrs-rating-show-option"
 						                name="fsrs-rating-show-option" class="checkbox"></label>
 						            </p>
 						            </div>';
			}
		} else if ( $post_type === 'post' ) {
			echo '
                        <div style="display: none;">
					    <input type="checkbox" value="1" id="fsrs-rating-show-option" checked="checked"
					    name="fsrs-rating-show-option" >
					    </div>';
		}
		echo '</div>'; ?>


        <div class="fsrs-schema-item">
            <fieldset data-role="controlgroup" name="fsrs-schema" id="fsrs-schema"
                      class="postbox fsrs-schema">
                <legend style="margin-bottom: 10px; padding-bottom: 8px" class="fsrs-h4"><?php esc_html_e('با چه روشی میخواهید صفحه شما ستاره دار شود؟',
                    'full-schema'); ?></legend>
                <label for="radio-choice-3"><?php esc_html_e('روش پیشفرض ', 'full-schema');?>
		            <?php
		            if ( $vObject['@type'] === 'MediaObject' ) {
			            echo '<input type="radio" name="fsrs-schema-radio"
 							  id="radio-choice-3" checked="checked" value="3" data-mini="true"/>';
		            } else {
			            echo '<input type="radio" name="fsrs-schema-radio"
 							  id="radio-choice-3" value="3" data-mini="true"/>';
		            }
		            ?>
                </label>
                <label for="radio-choice-1"><?php esc_html_e('ویدیو دارم ', 'full-schema');?>
				<?php
				if ( $vObject['@type'] === 'VideoObject' ) {
					echo '<input type="radio" name="fsrs-schema-radio" checked="checked"
 									 id="radio-choice-1" value="1" data-mini="true"/>';
				} else {
					echo '<input type="radio" name="fsrs-schema-radio" id="radio-choice-1" 
                                    value="1" data-mini="true"/>';
				}
				?>
                </label>
                <label for="radio-choice-2"><?php esc_html_e('فایل صوتی دارم ', 'full-schema');?>
				<?php
				if ( $vObject['@type'] === 'AudioObject' ) {
					echo '<input type="radio" name="fsrs-schema-radio" id="radio-choice-2"
 									 value="2" checked="checked" data-mini="true"/>';
				} else {
					echo '<input type="radio" name="fsrs-schema-radio" id="radio-choice-2" value="2"
                                    data-mini="true"/>';
				}
				?>
                </label>
            </fieldset>
            <div class="fsrs-video-object">
                <p>
                    <label for="fsrs-vo-title" class="fsrs-meta-label"><?php esc_html_e( 'عنوان',
							'full-schema' ); ?></label>
                    <input type="text" id="fsrs-vo-title" name="fsrs-vo-title" class="widefat fsrs-schema-input"
                           value="<?php echo esc_html( ! empty( $vObject['name'] ) ?
						       $vObject['name'] : '' ); ?>">
                </p>
                <p>
                    <label for="fsrs-vo-desc" class="fsrs-meta-label"><?php esc_html_e( 'توضیحات',
							'full-schema' ); ?></label>
                    <textarea id="fsrs-vo-desc" name="fsrs-vo-desc" rows="4"
                              class="widefat fsrs-schema-input" style="height: auto!important;"><?php
						echo esc_attr( ! empty( $vObject['description'] ) ?
							$vObject['description'] : '' ); ?></textarea>
                </p>
                <p>
                    <label for="fsrs-vo-duration"
                           class="fsrs-meta-label"><?php esc_html_e( 'مدت زمان (SثانیهMدقیقهPT)',
                            'full-schema' ); ?></label>
                    <input type="text" id="fsrs-vo-duration" name="fsrs-vo-duration"
                           class="widefat fsrs-schema-input" placeholder="" value="<?php
					echo esc_attr( ! empty( $vObject['duration'] ) ?
						$vObject['duration'] : '' ); ?>">
                </p>
                <p>
                    <label for="fsrs-vo-video-url"
                           class="fsrs-meta-label"><?php esc_html_e( 'url مدیای صفحه', 'full-schema' );
                           ?></label>
                    <input type="text" id="fsrs-vo-video-url" name="fsrs-vo-video-url"
                           class="widefat fsrs-schema-input" value="<?php
					echo esc_attr( ! empty( $vObject['contentUrl'] ) ?
						$vObject['contentUrl'] : '' ); ?>">
                </p>
            </div>
        </div>
    </div>