<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class FSRS_MAIL_TEMP {
	private static $instance;

	public function __construct() {

	}

	public function get_email_body( $user_email, $post_title, $post_url ): string {
		$body = '
        <!-- SECTION / BACKGROUND -->
        <!-- Set message background color one again -->
        <table width="100%" align="center" border="0" cellpadding="0" cellspacing="0"
               style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; width: 100%;"
               class="background">
            <tr>
                <td align="center" valign="top"
                    style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0;"
                    bgcolor="#F0F0F0">

                    <!-- WRAPPER -->
                    <!-- Set wrapper width (twice) -->
                    <table border="0" cellpadding="0" cellspacing="0" align="center"
                           width="560" style="border-collapse: collapse; border-spacing: 0; padding: 0; width: inherit;
	max-width: 560px;" class="wrapper">

                        <tr>
                            <td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%;
			padding-top: 20px;
			padding-bottom: 20px;">

                                <!-- LOGO -->
                                <!-- Image text color should be opposite to background color. Set your url, image src, alt and title. Alt text should fit the image size. Real image size should be x2. URL format: http://domain.com/?utm_source={{Campaign-Source}}&utm_medium=email&utm_content=logo&utm_campaign={{Campaign-Name}} -->
                                <img border="0" vspace="0"
                                                                                          hspace="0"
                                                                                          src="https://safine.net/wp-content/uploads/2021/04/5f47b7da7a33350cdd5d2028.png"
                                                                                          width="40" height="40"
                                                                                          alt="Logo" title="Logo"
                                                                                          style="
				color: #000000;
				font-size: 10px; margin: 0; padding: 0; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; border: none; display: block;"/>

                            </td>
                        </tr>

                        <!-- End of WRAPPER -->
                    </table>

                    <!-- WRAPPER / CONTEINER -->
                    <!-- Set conteiner background color -->
                    <table border="0" cellpadding="0" cellspacing="0" align="center"
                           bgcolor="#FFFFFF"
                           width="560" style="border-collapse: collapse; border-spacing: 0; padding: 0; width: inherit;
	max-width: 560px;" class="container">

                        <!-- HEADER -->
                        <!-- Set text color and font family ("sans-serif" or "Georgia, serif") -->
                        <tr>
                            <td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 24px; font-weight: bold; line-height: 130%;
			padding-top: 25px;
			color: #000000;
			font-family: tahoma;" class="header">
                                تبریک! یک کاربر ایمیل خود را ثبت کرد
                            </td>
                        </tr>

<!--

                        &lt;!&ndash; HERO IMAGE &ndash;&gt;
                        &lt;!&ndash; Image text color should be opposite to background color. Set your url, image src, alt and title. Alt text should fit the image size. Real image size should be x2 (wrapper x2). Do not set height for flexible images (including "auto"). URL format: http://domain.com/?utm_source={{Campaign-Source}}&utm_medium=email&utm_content={{Ìmage-Name}}&utm_campaign={{Campaign-Name}} &ndash;&gt;
                        <tr>
                            <td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0;
			padding-top: 20px;" class="hero"><img border="0"
                                                                                                       vspace="0"
                                                                                                       hspace="0"
                                                                                                       src="https://www.ppt-backgrounds.net/thumbs/party-vector-st-&#45;&#45;templates-backgrounds.jpg"
                                                                                                       alt="Please enable images to view this content"
                                                                                                       title="Hero Image"
                                                                                                       width="560"
                                                                                                       style="
			width: 100%;
			max-width: 560px;
			color: #000000; font-size: 13px; margin: 0; padding: 0; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; border: none; display: block;"/>
                            </td>
                        </tr>
-->

                        <!-- PARAGRAPH -->
                        <!-- Set text color and font family ("sans-serif" or "Georgia, serif"). Duplicate all text styles in links, including line-height -->
                        <tr>
                            <td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 17px; font-weight: 400; line-height: 160%;
			padding-top: 25px; 
			color: #000000;
			font-family: tahoma; text-align: center; direction: rtl" class="paragraph">
                                ایمیل کاربر: ' . $user_email . '
                            </td>
                        </tr>
 						<tr>
                    		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 17px; font-weight: 400; line-height: 160%;
									padding-top: 25px;
									color: #000000;
									font-family: tahoma; text-align: center; direction: rtl" class="paragraph">
		                        مقاله: ' . $post_title . '
                    		</td>
             		    </tr>
             		    <tr>
                    		<td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 17px; font-weight: 400; line-height: 160%;
									padding-top: 25px;
									color: #000000;
									font-family: tahoma; text-align: center; direction: rtl" class="paragraph">
		                        <a href="' . $post_url . '" target="_blank">برای مشاهده مقاله کلیک کنید</a>
                    		</td>
             		    </tr>

                        <!-- LINE -->
                        <!-- Set line color -->
                        <tr>
                            <td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%;
			padding-top: 25px;" class="line">
                                <hr
                                        color="#E0E0E0" align="center" width="100%" size="1" noshade
                                        style="margin: 0; padding: 0;"/>
                            </td>
                        </tr>

             

                        <!-- End of WRAPPER -->
                    </table>

                    <!-- WRAPPER -->
                    <!-- Set wrapper width (twice) -->
                    <table border="0" cellpadding="0" cellspacing="0" align="center"
                           width="560" style="border-collapse: collapse; border-spacing: 0; padding: 0; width: inherit;
	max-width: 560px;" class="wrapper">

                        <!-- FOOTER -->
                        <!-- Set text color and font family ("sans-serif" or "Georgia, serif"). Duplicate all text styles in links, including line-height -->
                        <tr>
                            <td align="center" valign="top" style="border-collapse: collapse; border-spacing: 0; margin: 0; padding: 0; padding-left: 6.25%; padding-right: 6.25%; width: 87.5%; font-size: 13px; font-weight: 400; line-height: 150%;
			padding-top: 20px;
			padding-bottom: 20px;
			color: #999999;
			font-family: sans-serif;" class="footer">

                               شما این ایمیل را از طریق افزونه فول اسکیما دریافت کرده اید.

                                <!-- ANALYTICS -->
                                <!-- https://www.google-analytics.com/collect?v=1&tid={{UA-Tracking-ID}}&cid={{Client-ID}}&t=event&ec=email&ea=open&cs={{Campaign-Source}}&cm=email&cn={{Campaign-Name}} -->
                                <img width="1" height="1" border="0" vspace="0" hspace="0"
                                     style="margin: 0; padding: 0; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; border: none; display: block;"
                                     src="https://raw.githubusercontent.com/konsav/email-templates/master/images/tracker.png"/>

                            </td>
                        </tr>

                        <!-- End of WRAPPER -->
                    </table>

                    <!-- End of SECTION / BACKGROUND -->
                </td>
            </tr>
        </table>';

		return $body;

	}

	/**
	 * @return mixed
	 */
	public static function get_instance(): FSRS_MAIL_TEMP {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}
}
