<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
if ( empty( $faqs ) ) {
	$faqs = [
		[
			'q' => '',
			'a' => '',
		],
	];
}
?>
<div class="fsrs-rating-header fsrs-faq-div" onclick="hideParentChild('fsrs-tax-faq-schema-container')"
     style="border: 1px solid #d8d2d2 !important;">
    <h3>
                    <span class="dashicons dashicons-edit-large"
                          style="font-size: 24px; color: #ffba00; margin-left: 4px;"></span>
        <span class="h3"><?php esc_html_e( 'اسکیما سوال و جواب', 'full-schema' ); ?></span>
    </h3>
</div>
<div class="fsrs-tax-faq-schema-container" id="fsrs-tax-faq-schema-container">
    <input type="hidden" name="fsrs-faq-schema-nonce"
           value="<?php echo esc_attr( wp_create_nonce( 'fsrs-faq-schema' ) ); ?>">
    <div class="fsrs-faq-schema-items">
		<?php foreach ( $faqs as $index => $faq ) : ?>
            <div class="fsrs-faq-schema-item">
                <div class="fsrs-faq-schema-header">
							<span>
								<?php
								/* translators: index */
								echo esc_html( ! empty( $faq['q'] ) ? $faq['q'] : sprintf( __( 'سوال #%s',
									'fsrs-faq-schema' ), $index + 1 ) );
								?>
							</span>
                    <button class="fsrs-faq-schema-delete" type="button">
                        <span class="dashicons dashicons-trash"></span></button>
                </div>
                <div class="fsrs-faq-schema">
                    <p>
                        <label for="fsrs-faq-schema-q-<?php echo esc_attr( $index ); ?>"
                               class="fsrs-meta-label">
							<?php esc_html_e( 'سوال', 'full-schema' ); ?></label>
                        <input type="text" id="fsrs-faq-schema-q-<?php echo esc_attr( $index ); ?>"
                               name="fsrs-faq-schema[<?php echo esc_attr( $index ); ?>][q]"
                               class="widefat fsrs-schema-input" style="height: auto!important;"
                               value="<?php echo esc_attr( ! empty( $faq['q'] ) ? $faq['q'] : '' ); ?>">
                    </p>
                    <p>
                        <label for="fsrs-faq-schema-a-<?php echo esc_attr( $index ); ?>"
                               class="fsrs-meta-label">
							<?php esc_html_e( 'جواب', 'fsrs-faq-schema' ); ?></label>
                        <textarea name="fsrs-faq-schema[<?php echo esc_attr( $index ); ?>][a]"
                                  id="fsrs-faq-schema-a-<?php echo esc_attr( $index ); ?>" rows="3"
                                  style="height: auto!important;"
                                  class="widefat fsrs-schema-input"><?php echo esc_html( ! empty( $faq['a'] )
								? $faq['a'] : '' ); ?></textarea>
                    </p>
                </div>
            </div>
		<?php endforeach; ?>
    </div>
	<?php /* translators: index */ ?>
    <button type="button" class="button button-primary fsrs-faq-schema-add"
            data-index="<?php echo count( $faqs ); ?>"
            data-title="<?php esc_attr_e( 'سوال #%s', 'full-schema' ); ?>">
		<?php esc_html_e( 'اضافه کردن یک سوال جدید', 'full-schema' ); ?>
    </button>
</div>
<script type="text/html" id="tmpl-faq-schema-form">
    <div class="fsrs-faq-schema-item">
        <div class="fsrs-faq-schema-header">
            <span>{TITLE}</span>
            <button class="fsrs-faq-schema-delete" type="button">
                <span class="dashicons dashicons-trash"></span></button>
        </div>
        <div class="fsrs-faq-schema">
            <p>
                <label for="fsrs-faq-schema-q-{INDEX}"
                       class="fsrs-meta-label"><?php esc_html_e( 'سوال', 'full-schema' ); ?></label>
                <input type="text" id="fsrs-faq-schema-q-{INDEX}" name="fsrs-faq-schema[{INDEX}][q]"
                       class="widefat fsrs-schema-input">
            </p>
            <p>
                <label for="fsrs-faq-schema-a-{INDEX}"
                       class="fsrs-meta-label"><?php esc_html_e( 'جواب', 'full-schema' ); ?></label>
                <textarea id="fsrs-faq-schema-a-{INDEX}" name="fsrs-faq-schema[{INDEX}][a]" rows="3"
                          style="height: auto!important;"
                          class="widefat fsrs-schema-input"></textarea>
            </p>
        </div>
    </div>
</script>