<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
$notif_size = 0;
$fsrs_promo = get_option( 'fsrs_promo', array() );
$notif_option_content = get_option( 'fsrs_notif_option', ' ' );
$notif_content        = $notif_option_content['notif_content'] ?? '';
if ( $notif_content !== ( $fsrs_promo['content'] ?? '' ) ) {
	$this->notif_size = $fsrs_promo['count'];
}
?>
  <div class="fsrs-wrapper">
            <div class="fsrs-alert-container fsrs-guide-alert">
                <h3 class="fsrs-setting-box" id="fsrs-setting-rating"
                    onclick="hideParentChild('fsrs-setting-rating-guide')">
                    <span class="fas fa-book"
                          style="color: #f16334!important; margin-left: 12px!important;"></span><?php
                    esc_html_e('آموزش استفاده فول اسکیما',
                    'full-schema') ?>
                </h3>
                <div class="fsrs-setting-rating-guide" id="fsrs-setting-rating-guide">
					<?php
					print $fsrs_promo['alert'];
					?>
                </div>
            </div>
            <div class="fsrs-alert-container fsrs-info-alert">
                <h3 class="fsrs-setting-box" id="fsrs-setting-rating">
                    <span class="fas fa-info-circle" style="margin-left: 12px!important;color:#f16334"></span>
                    <?php esc_html_e('اطلاعیه‌ها', 'full-schema'); ?>
					<?php if ( $notif_size > 0 ) { ?>
                        <span class="fsrs-main-notif" style="background: #f16334;
                            font-size: 14px;
                            display: inline-block;
                            width: 20px;
                            height: auto;
                            text-align: center;
                            font-family: inherit;
                            padding: 3px;
                            border-radius: 100px;
                            color: white;
                            font-weight: 600;"><?php echo $notif_size ?>
							</span> <?php } ?>
                    <span class="dashicons dashicons-visibility" id="fsrs-notif-is-seen"
                          style="float: left; cursor: pointer"></span>
                    <input type="hidden" value="<?php echo $notif_size ?>" id="notif-size">
                    <input type="hidden" value="<?php echo $fsrs_promo['content'] ?>" id="notif-body">
                </h3>
                <div class="fsrs-setting-rating-guide" id="fsrs-setting-rating-guide">
					<?php
					print $fsrs_promo['content'];
					?>
                </div>
            </div>
        </div>