<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
class FSRS_ACTIVATION {
	public function __construct() {
		$this->setup_activation_view();
		$this->enqueue_scripts();
	}

	public function setup_activation_view() {
		$is_licensed = get_option( 'fsrs-pr-license' );
		$valid       = get_option( 'fsrs_pr_option', '0' );
		if ( empty( $is_licensed ) || $valid['valid'] === '0' ) { ?>
            <div class="fsrs-activation-container">
                <div class="fsrs-activate-header">
                    <h2 style="color:white; padding: 24px; margin: 0"><?php esc_html_e( 'فعالسازی فول اسکیما', 'full-schema' ); ?></h2>
                </div>
                <div class="not-active">
                    <img src="<?php echo FSRS_ADMIN_URL . 'image/fail.png' ?>" alt="">
                    <h4 style="color: #ff5a6f; margin-bottom: 32px; margin-top: 8px"><?php esc_html_e( 'متاسفانه هنوز افزونه را فعال نکردید!',
							'full-schema' ); ?></h4>
                </div>
                <p class="fsrs-activation-txt-helper"> <?php esc_html_e( 'کدی که از سایت',
						'full-schema' ); ?> <a href="https://zhaket.com">ژاکت</a><?php
					esc_html_e( ' دریافت کردید را اینجا وارد کنید و روی دکمه‌ی فعال کردن افزونه کلیک کنید. ',
						'full-schema' ); ?></p>
                <div class="input-group mb-3 active-input-container">
                    <span class="input-group-text" id="inputGroup-sizing-default"><?php
	                    esc_html_e( 'کد فعالسازی', 'full-schema' ); ?></span>
                    <input id="activation-field" type="text" class="form-control" aria-label="Sizing example input"
                           aria-describedby="inputGroup-sizing-default" required>
                </div>
                <button class="btn btn-outline-success btn-submit-activation"
                        id="btn-submit-activation" type="submit"><?php esc_html_e( 'فعال کردن افزونه',
                        'full-schema' ); ?></button>
                <div class="response-text"></div>
                <input id="fsrs-active-nonce" type="hidden"
                       value="<?php echo wp_create_nonce( 'fsrs-activation-nonce' ) ?>">
            </div>
		<?php } else if ( $valid['valid'] === '1' ) {
			include FSRS_ADMIN_DIR . 'template/fsrs-is-active-temp.php';
		}
	}

	public function enqueue_scripts() {
		?>
        <script>
            jQuery(document).ready(function ($) {
                let btnActivation = $('.btn-submit-activation');
                let activationField =  $('#activation-field');
                setupValidity();
                activationField.on('keydown keyup change', function (e) {
                    setupValidity();
                });

                function setupValidity() {
                    if (activationField.val()) {
                        let activationLength = activationField.val().length;
                        if (activationLength < 1) {
                            btnActivation.hide();
                        } else {
                            btnActivation.show();
                        }
                    }
                }
            });
        </script>
		<?php
	}
}