<?php

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
final class FSRS_TAB_STARS_TEXT {
	private static $instance;

	public function __construct() {
		ob_start();
		$this->customize_texts();
		echo ob_get_clean();
	}

	public function customize_texts() {
		$star_settings = get_option( 'fsrs_star_texts', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::star_texts() );
		/*if ( function_exists( 'icl_register_string' ) ) {
			icl_register_string( 'full-schema', 'فیلد متن ستاره اول', $star_settings['star1'],
				false, 'en' );
			icl_register_string( 'full-schema', 'فیلد متن ستاره دوم', $star_settings['star2'],
				false, 'en' );
			icl_register_string( 'full-schema', 'فیلد متن ستاره سوم', $star_settings['star3'] ,
				false, 'en' );
			icl_register_string( 'full-schema', 'فیلد متن ستاره چهارم', $star_settings['star4'] ,
				false, 'en' );
			icl_register_string( 'full-schema', 'فیلد متن ستاره پنجم', $star_settings['star5'] ,
				false, 'en' );
		}*/ ?>
        <div class="fsrs-alert-container">
            <h3 class="fsrs-setting-box" id="fsrs-setting-rating" onclick="hideParentChild('fsrs-admin-form')">
                <span class="dashicons dashicons-admin-customizer"></span>
				<?php esc_html_e( 'سفارشی سازی متن امتیازها', 'full-schema' ); ?>
            </h3>
            <div id="fsrs-admin-form">
                <form action="#" id="star-text-customize-form" enctype="multipart/form-data">
                    <div class="fsrs-alert-container-item fsrs-alert-container" style="margin-bottom: 16px;">
                        <table class="form-table">
                            <tr valign="top">
                                <th scope="row" class="titledesc">
                                    <label for="fsrs-first-rating"><?php esc_html_e( 'متن ستاره اول',
											'full-schema' ); ?></label>
                                </th>
                                <td class="forminp forminp-text">
                                    <input type="text" name="star1" id="fsrs-first-rating"
                                           value="<?php echo __( esc_html($star_settings['star1']), 'full-schema' ); ?>">
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row" class="titledesc">
                                    <label for="fsrs-second-rating"><?php esc_html_e( 'متن ستاره دوم',
											'full-schema' ); ?></label>
                                </th>
                                <td class="forminp forminp-text">
                                    <input type="text" name="star2" id="fsrs-second-rating"
                                           value="<?php echo __( esc_html($star_settings['star2']), 'full-schema' ); ?>">
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row" class="titledesc">
                                    <label for="fsrs-third-rating"><?php esc_html_e( 'متن ستاره سوم',
											'full-schema' ); ?></label>
                                </th>
                                <td class="forminp forminp-text">
                                    <input type="text" name="star3" id="fsrs-third-rating"
                                           value="<?php echo __( esc_html($star_settings['star3']), 'full-schema' ); ?>">
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row" class="titledesc">
                                    <label for="fsrs-four-rating"><?php esc_html_e( 'متن ستاره چهارم',
											'full-schema' ); ?></label>
                                </th>
                                <td class="forminp forminp-text">
                                    <input type="text" name="star4" id="fsrs-four-rating"
                                           value="<?php echo __( esc_html($star_settings['star4']), 'full-schema' ); ?>">
                                </td>
                            </tr>
                            <tr valign="top">
                                <th scope="row" class="titledesc">
                                    <label for="fsrs-five-rating"><?php esc_html_e( 'متن ستاره پنجم',
											'full-schema' ); ?></label>
                                </th>
                                <td class="forminp forminp-text">
                                    <input type="text" name="star5" id="fsrs-five-rating"
                                           value="<?php echo __( esc_html($star_settings['star5']), 'full-schema' ); ?>">
                                </td>
                            </tr>
                        </table>
                        <div class="form-group">
                            <button class="btn btn-success" type="submit"
                                    style="margin-top: 16px; margin-bottom: 12px; color: white"
                                    id="fsrs_save_star_texts"><?php esc_html_e( 'ثبت تغییرات',
									'full-schema' ); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
		<?php
	}

	public static function get_instance(): FSRS_TAB_STARS_TEXT {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}
}