<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

final class FSRS_TAB_MARKETING {
	private static $instance;

	public function __construct() {
		$this->init_view();
	}

	public function init_view() {
		$marketing_settings = get_option( MARKETING_OPTION_NAME,
			FULL_SCHEMA_RICH_SNIPPET_SETTINGS::marketing_def_settings() );
		?>
        <div class="container">
            <div class="row">
                <h5 style="margin-top: 24px"><?php esc_html_e('تنظیمات سئو و مارکتینگ', 'full-schema'); ?></h5>
                <form action="#" id="fsrsMarketingForm" class="form mb-3" enctype="multipart/form-data">
                    <input type="hidden" name="fsrs_marketing_wpnonce" id="fsrs_marketing_wpnonce"
                           value="<?php esc_attr_e(wp_create_nonce( 'fsrs_marketing_nonce' )); ?>">
                    <table class="form-table">
                        <tbody>
						<?php
						$fields    = $this->get_marketing_settings();
						foreach ( $fields as $field ):
							$field_name = $field['name'];
							if ( is_null( $marketing_settings[ $field_name ] ) ) {
								$default_marketing_setting = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::marketing_def_settings();
								$value           = $default_marketing_setting[ $field_name ];
							} else {
								$value = $marketing_settings[ $field_name ];
							} ?>
                            <tr class="<?php esc_attr_e($field_name); ?>">
                                <th scope="row">
									<?php esc_html_e( $field['title'], 'full-schema' ); ?>
                                </th>
                                <td class="align-middle">
									<?php
									if ( $field['field_type'] === 'switch' ) :
										UI::getInstance()->render_toggle_switch( $field['title'], $value, $field_name );
                                    elseif ( $field['field_type'] === 'input' ):
										UI::getInstance()->render_input($field['title'], $value, $field_name,
											$field_name);
                                    elseif ($field['field_type'] === 'textarea'):
										UI::getInstance()->render_textarea($value, $field_name, $field_name);
									endif; ?>
                                    <div class="fsrs-field-helper-text">
                                        <p><?php esc_html_e( $field['help_text'], 'full-schema' ); ?></p>
                                    </div>
                                </td>
                            </tr>
						<?php endforeach; ?>
                        </tbody>
                    </table>
                    <div class="fixed-bottom" style="right: auto!important;margin-bottom: 32px;margin-left: 32px;">
                        <button class="btn btn-primary" style="margin-top: 16px; transition: 0.2s!important;"
                                id="fsrs-marketing-settings-save"><?php esc_html_e( 'ثبت تغییرات',
								'full-schema' ); ?></button>
                    </div>
                </form>
            </div>
        </div>
		<?php
	}

	private function get_marketing_settings(): array {
		return array(
			array(
				'title'      => __( 'پنجره اشتراک محتوا نمایش داده شود؟ ', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_share_dialog_show' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'با فعال کردن این گزینه، پس از ثبت رای توسط کاربر یک پنجره
                 برای اشتراک گذاری محتوا به او نشان داده می‌شود.', 'full-schema' )
			),
            array(
				'title'      => __( 'عنوان پنجره', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_share_dialog_title' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'این عنوان در پنجره به کاربران نشان داده می‌شود.', 'full-schema' )
			),
			array(
				'title'      => __( 'اشتراک گذاری لینکدین نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_share_linkedin_show' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'با فعال کردن این گزینه، کاربران می‌توانند آدرس صفحه را در لینکدین به اشتراک بگذارند.',
					'full-schema' )
			),
			array(
				'title'      => __( 'اشتراک گذاری توییتر نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_share_twitter_show' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'با فعال کردن این گزینه، کاربران می‌توانند آدرس صفحه را در توییتر به اشتراک بگذارند.',
					'full-schema' )
			),
			array(
				'title'      => __( 'اشتراک گذاری فیسبوک نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_share_facebook_show' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'با فعال کردن این گزینه، کاربران می‌توانند آدرس صفحه را در فیسبوک به اشتراک بگذارند.',
					'full-schema' )
			),
            array(
				'title'      => __( 'اشتراک گذاری تلگرام نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_share_telegram_show' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'با فعال کردن این گزینه، کاربران می‌توانند آدرس صفحه را در تلگرام به اشتراک بگذارند.',
                    'full-schema' )
			),
			array(
				'title'      => __( 'اشتراک گذاری از طریق ایمیل نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_share_email_show' ),
				'field_type' => esc_attr( 'switch'),
				'help_text'  => __( 'با فعال کردن این گزینه، کاربران می‌توانند آدرس صفحه را از طریق ایمیل ارسال کنند.',
					'full-schema' )
			),
			array(
				'title'      => __( 'پنجره دریافت اطلاعات کاربر نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_user_info_dialog_show' ),
				'field_type' => esc_attr( 'switch'),
				'help_text'  => __( 'در صورت فعال کردن این گزینه
				 .قبل از نمایش پنجره اشتراک گذاری پنجره‌ای نمایش داده می‌شود تا ایمیل کاربر را دریافت کند.' )
			),
            array(
				'title'      => __( 'عنوان پنجره دریافت اطلاعات کاربر', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_get_user_info_title' ),
				'field_type' => esc_attr( 'input'),
				'help_text'  => __( 'این عنوان در پنجره‌ای که برای دریافت ایمیل کاربران است،
				 نمایش داده می‌شود.' )
			),
            array(
				'title'      => __( 'ایمیل شما', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_admin_mail' ),
				'field_type' => esc_attr( 'input'),
				'help_text'  => __( ' پس از اینکه کاربر ایمیل را ثبت کرد، به آدرس ایمیلی که وارد می‌کنید فرستاده می‌شود.' )
			),
            array(
				'title'      => __( 'متن کمکی داخل فیلد', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_email_field_helper_text'),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'متنی که داخل فیلد ایمیل به صورت کمرنگ نمایش داده می‌شود.' )
			),
            array(
				'title'      => __( 'متن خطا', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_email_error_text'),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'در صورتی که کاربر فیلد را خالی بگذارد و یا ایمیل نامعتبر وارد کند
				این متن به او نشان داده می‌شود.' )
			),
			array(
				'title'      => __( 'متن حریم خصوصی', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_user_privacy_text'),
				'field_type' => esc_attr( 'textarea' ),
				'help_text'  => __( 'می‌توانید با استفاده از این متن به کاربران خود این اطمینان را بدهید که اطلاعات آن‌ها نزد شما محفوظ است.' )
			),
            array(
				'title'      => __( 'متن دکمه ثبت', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_user_info_submit_text'),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'متن دکمه ثبت برای دریافت ایمیل.' )
			),
            array(
				'title'      => __( 'متن دکمه رد کردن', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_user_info_deny_text'),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'کاربر با کلیک روی این دکمه فرم را می‌بندد.' )
			),array(
				'title'      => __( 'متن تشکر', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_user_info_thanks_text'),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'پس از اینکه کاربر ایمیل خود را ثبت می‌کند، در صورتی که گزینه نمایش پنجره
				اشتراک محتوا فعال نباشد، این متن در یک پنجره به او نمایش داده می‌شود.' )
			),
		);
	}

	public static function get_instance(): FSRS_TAB_MARKETING {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}

}