<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
$pre_con               = '';
$post_id               = get_the_ID();
$def_settings          = get_option( 'fsrs_def_settings', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::design_def_settings() );
$live_rating_font_size = $def_settings['fsrs_st_down_font_size'];
$rating_data           = FSRS_COMMON::get_post_rating( get_the_ID() );
$hint_margin           = (int) $def_settings['fsrs_st_down_star_size'] - 5;
$rating_fa_value       = FSRS_COMMON::convert_english_to_persian_number( $rating_data['rating'] );
$seen_count_fa_value   = FSRS_COMMON::convert_english_to_persian_number( $rating_data['seen_count'] );
$star_shape            = $def_settings['fsrs_star_shape'] ?? 'rounded';
$normal_color          = $def_settings['fsrs_normal_color'] ?? '#FFD700';
$rated_color           = $def_settings['fsrs_rated_color'] ?? '#FFC312';
$hover_color           = $def_settings['fsrs_hover_color'] ?? '#FFC312';
$star_direction        = $def_settings['fsrs_star_direction'] ?? 'ltr';
?>
    <div class="safine-full-schema-container">
        <div class="fsrs-rating" id="fsrs-rating"
             style="text-align: center; direction: <?php echo $star_direction ?>"
             data-rating="<?php echo $rating_data['rating'] ?>" star-shape="<?php echo $star_shape ?>"
             rated-color="<?php echo $rated_color ?>" hover-color="<?php echo $hover_color ?>"
             normal-color="<?php echo $normal_color ?>"></div>
        <div class="fsrs-rating-hint" style="direction: <?php esc_attr_e( $star_direction ); ?>">
            <div class="fsrs-hint-label"
                 style="width:<?php echo $hint_margin ?>px; margin-right: -4px;"><?php esc_html_e( '۱',
					'full-schema' ); ?></div>
            <div class="fsrs-hint-label"
                 style="width:<?php echo $hint_margin ?>px"><?php esc_html_e( '۲', 'full-schema' ); ?></div>
            <div class="fsrs-hint-label"
                 style="width:<?php echo $hint_margin ?>px"><?php esc_html_e( '۳', 'full-schema' ); ?></div>
            <div class="fsrs-hint-label"
                 style="width:<?php echo $hint_margin ?>px"><?php esc_html_e( '۴', 'full-schema' ); ?></div>
            <div class="fsrs-hint-label"
                 style="width:<?php echo $hint_margin ?>px"><?php esc_html_e( '۵', 'full-schema' ); ?></div>
        </div>
        <div style="text-align: center; margin-top: 10px;">
            <span class="rating-hov-text fsrs-h2" style="font-size:<?php echo $live_rating_font_size ?>px"></span></div>

		<?php
		if ( $def_settings['fsrs_show_progress'] === '1' ) {
			?>
            <div style="width: 100%; text-align: center">
                <div class="lds-ellipsis" style="display: none">
<!--                    <img src="--><?php //echo FSRS_ASSETS_DIR . '/image/fsrs-loading.gif' ?><!--"/>-->
                    <div class="loadingio-spinner-spin-9gqz2hyvr1r"><div class="ldio-nsbqh63uhd">
                            <div><div></div></div><div><div></div></div><div><div></div></div><div><div></div></div><div><div></div></div><div><div></div></div><div><div></div></div><div><div></div></div><div><div></div></div>
                        </div></div>

                </div>
            </div>
		<?php }
		?>
        <div class="live-rating fsrs-h4" style="
                font-size: <?php echo $live_rating_font_size ?>px">
				        <span class="fsrs-ratings-info"><?php esc_html_e( 'میانگین امتیازات ',
						        'full-schema' ); ?> <strong>
                            <?php echo $rating_fa_value ?>
                            </strong> <?php esc_html_e( ' از ۵', 'full-schema' ); ?> </span>
        </div>
        <input type="hidden" id="post-id" value="<?php echo $post_id ?>">
		<?php
		if ( $def_settings['fsrs_show_number_of_votes'] === '1' ) {
			?>
            <div class="live-rating live-rating-count fsrs-h4" style="
                    font-size: <?php echo $live_rating_font_size ?>px">
			    	 <span class=fsrs-ratings-info> <?php esc_html_e( 'از مجموع ', 'full-schema' ); ?> <strong>
                        <?php echo $seen_count_fa_value ?> </strong> <?php esc_html_e( 'رای',
						     'full-schema' ); ?></span>
            </div>

		<?php } ?>
    </div>
<?php

