<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
class FSRS_ACTIVATOR {
	public static function activate() {
		$license_key = '';
		add_option( 'license_key', $license_key );
		if ( get_option( 'fsrs_def_settings' ) === null || ( get_option( 'fsrs_def_settings' ) < 1
		                                                     && get_option( 'fsrs_star_texts' ) === null ) ||
		     get_option( 'fsrs_star_texts' ) < 1 ) {
			add_option( 'fsrs_def_settings', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::design_def_settings() );
			add_option( 'fsrs_star_texts', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::star_texts() );
		}
		if ( !wp_next_scheduled( 'fsrs_daily_check_promotion' )) {
			wp_schedule_event( time(), 'twicedaily', 'fsrs_daily_check_promotion' );
		}
		if (!wp_next_scheduled('fsrs_daily_check_validity')) {
			wp_schedule_event(time(), 'daily', 'fsrs_daily_check_validity');
		}
	}

}
