<?php

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class FULL_SCHEMA_RICH_SNIPPET_SETTINGS {

	public static function default_options( $post_id, $title, $rating = array() ): array {
		if ( ! isset( $rating ) ) {
			$rating = '';
		}

		return array(
			'@context'        => 'https://schema.org/',
			'@type'           => 'MediaObject',
			'uploadDate'      => mysql2date( 'Y-m-d', get_post( $post_id )->post_date_gmt, false ),
			'name'            => $title,
			'aggregateRating' => $rating
		);
	}

	public static function video_object_options( $postId, $title, $desc, $time, $contentUrl, $rating = array() ): array {
		if ( ! isset( $rating ) ) {
			$rating = '';
		}
		$thumbnail = '';
		if ( ! get_the_post_thumbnail( $postId ) === false ) {
			$thumbnail = get_the_post_thumbnail_url( $postId );
		}

		return array(
			'@context'        => 'https://schema.org/',
			'@type'           => 'VideoObject',
			'name'            => $title,
			'description'     => $desc,
			'duration'        => $time,
			'thumbnailUrl'    => $thumbnail,
			'uploadDate'      => mysql2date( 'Y-m-d', get_post( $postId )->post_date_gmt, false ),
			'contentUrl'      => $contentUrl,
			'aggregateRating' => $rating
		);
	}

	public static function audio_object_options( $duration, $title, $desc, $contentUrl, $rating = array() ): array {
		if ( ! isset( $rating ) ) {
			$rating = '';
		}

		return array(
			'@context'        => 'https://schema.org/',
			'@type'           => 'AudioObject',
			'contentUrl'      => $contentUrl,
			'description'     => $desc,
			'duration'        => $duration,
			'encodingFormat'  => 'audio/mpeg',
			'name'            => $title,
			'aggregateRating' => $rating
		);
	}

	public static function design_def_settings(): array {
		return array(
			'fsrs_st_up_star_size'        => 25,
			'fsrs_st_down_star_size'      => 37,
			'fsrs_post_st_up_star_show'   => '1',
			'fsrs_page_st_up_star_show'   => '1',
			'fsrs_st_down_thanks_text'    => 'تشکر! رای شما ثبت شد.',
			'fsrs_st_down_font_size'      => 20,
			'fsrs_show_progress'          => '1',
			'fsrs_show_number_of_votes'   => '1',
			'fsrs_star_direction'         => 'ltr',
			'fsrs_star_shape'             => 'rounded',
			'fsrs_normal_color'           => '#FFD700',
			'fsrs_rated_color'            => '#FFD700',
			'fsrs_hover_color'            => '#FFD700',
			'fsrs_st_down_bg_color'       => '#ffffff',
			'fsrs_st_down_border_color'   => '#e2e1e1',
			'fsrs_st_down_frame_bg_color' => '#ffffff',
			'fsrs_st_down_texts_color'    => '#353535',
		);
	}

	public static function marketing_def_settings(): array {
		return array(
			'fsrs_share_dialog_show'       => '1',
			'fsrs_user_info_dialog_show'   => '0',
			'fsrs_share_dialog_title'      => 'آیا تمایل دارید این پست را به اشتراک بگذارید؟',
			'fsrs_share_linkedin_show'     => '1',
			'fsrs_share_twitter_show'      => '1',
			'fsrs_share_facebook_show'     => '1',
			'fsrs_share_telegram_show'     => '0',
			'fsrs_share_email_show'        => '0',
			'fsrs_get_user_info_title'     => 'برای اطلاع از آخرین اخبار سایت ایمیل خود را وارد کنید.',
			'fsrs_email_field_helper_text' => 'بهترین ایمیلتان را وارد کنید!',
			'fsrs_email_error_text'        => 'لطفا ایمیل معتبر وارد کنید!',
			'fsrs_user_privacy_text'       => 'اطلاعات شما نزد ما محفوظ است.',
			'fsrs_admin_mail'              => get_option( 'admin_email' ),
			'fsrs_user_info_submit_text'   => 'ثبت ایمیل',
			'fsrs_user_info_deny_text'     => 'فعلا نه!',
			'fsrs_user_info_thanks_text'   => 'ممنون از اینکه مارو همراهی می‌کنید.',
		);
	}

	public static function star_texts(): array {
		return array(
			'star1' => __( 'بد', 'full-schema' ),
			'star2' => __( 'متوسط', 'full-schema' ),
			'star3' => __( 'خوب', 'full-schema' ),
			'star4' => __( 'عالی', 'full-schema' ),
			'star5' => __( 'بسیار عالی', 'full-schema' )
		);
	}
}