<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
$post_id      = get_the_ID();
$post_scripts = get_post_meta( $post_id, '_fsrs_script', true );
?>
<div class="fsrs-rating-header fsrs-script-div" onclick="hideParentChild('fsrs-script-div-count')">
    <h3>
                <span class="dashicons dashicons-plus-alt2"
                      style="font-size: 24px; color: #ffba00; margin-left: 4px; margin-top: -3px"></span>
        <span class="h3"><?php esc_html_e('تزریق اسکریپت', 'full-schema'); ?></span>
    </h3>
</div>
<div class="fsrs-script-div-count" id="fsrs-script-div-count">
    <div class="fsrs-script-container">
        <input type="hidden" name="fsrs-script-nonce"
               value="<?php echo esc_attr( wp_create_nonce( 'fsrs-script' ) ); ?>">
        <p>
            <label for="fsrs-script-header" class="fsrs-meta-label"><?php esc_html_e( 'تزریق کد به هدر (header)',
					'full-schema' ); ?></label>
            <textarea id="fsrs-script-header" rows="7" name="fsrs-script-header" class="widefat fsrs-schema-input"
                      style="height: auto!important; direction: ltr" placeholder="<?php esc_html_e('کد را اینجا وارد کنید',
                'full-schema'); ?>"><?php
				echo esc_html( ! empty( $post_scripts['header'] ) ? $post_scripts['header'] : '' ); ?></textarea>
        </p>
        <p>
            <label for="fsrs-script-footer" class="fsrs-meta-label"><?php esc_html_e( 'تزریق کد به فوتر (footer)',
					'full-schema' ); ?></label>
            <textarea id="fsrs-script-footer" rows="7" name="fsrs-script-footer" class="widefat fsrs-schema-input"
                      style="height: auto!important; direction: ltr" placeholder="<?php esc_html_e('کد را اینجا وارد کنید',
                'full-schema'); ?>"><?php
				echo esc_html( ! empty( $post_scripts['footer'] ) ? $post_scripts['footer'] : '' ); ?></textarea>
        </p>
    </div>
</div>
