<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
?>
<div>
    <div class="fsrs-activation-container">
        <div class="fsrs-activate-header" style="background-color: #08AEEA;!important;
        background-image: linear-gradient(66deg, #08AEEA 0%, #2AF598 100%);!important;">
            <h2 class="fsrs-is-active-header"><?php esc_html_e( 'فول‌اسکیما', 'full-schema' ) ?></h2>
        </div>
        <div class="active">
            <img src="<?php echo FSRS_ADMIN_URL . 'image/success.png' ?>" alt="">
            <h4 class="fsrs-is-active-notice-headline"><?php esc_html_e( 'تبریک! افزونه فعال است.',
					'full-schema' ) ?></h4>
            <p class="fsrs-active-data"><?php esc_html_e( 'لایسنس: ',
					'full-schema' );
				echo ' ' . ( get_option( 'fsrs-pr-license' ) ) ?>
            </p>
            <p class="fsrs-active-data"><?php
				esc_html_e( 'دامنه: ', 'full-schema' );
				echo FSRS_COMMON::get_instance()->get_host() ?>
            </p>
            <p class="fsrs-active-data"><?php
				esc_html_e( 'ورژن افزونه: ',
					'full-schema' );
				echo FULL_SCHEMA_RICH_SNIPPET_VERSION ?>
            </p>
        </div>
        <div style="text-align: center; width: 100%">
            <button type="button" class="btn btn-info fsrs-check-validity" style="color: white"><?php
	            esc_html_e( 'بررسی وضعیت لایسنس', 'full-schema' ); ?></button>
            <span class="check-validity-response"></span>
        </div>
    </div>
</div>
<input type="hidden" id="fsrs-invalid-license" value="<?php
esc_html_e( 'لایسنس شما نامعتبر است. لطفا لایسنس معتبر وارد کنید!', 'full-schema' ); ?>">
<input type="hidden" id="fsrs-valid-license" value="<?php
esc_html_e( 'لایسنس شما فعال است.', 'full-schema' ); ?>">
<script>
    jQuery(document).ready(function ($) {
        const admin_url = "<?php echo admin_url( 'admin-ajax.php' )?>";
        const nonce = "<?php echo wp_create_nonce( 'fsrs-check-validity-nonce' )?>";
        $('.fsrs-check-validity').on('click', function (e) {
            e.preventDefault();
            let checkValidityResponse =  $('.check-validity-response');
            let checkValidity = $(this);
            checkValidity.html('لطفا منتظر بمانید <span class="spinner-border spinner-border-sm mr-2" ' +
                'role="status" aria-hidden="true" style="margin-bottom: 8px; margin-left: 8px;"></span>')
                .attr('disabled', true);
            var data = {
                action: "fsrs_check_validity",
                nonce: nonce
            };
            jQuery.ajax({
                type: "POST",
                dataType: "json",
                url: admin_url,
                data: data,
                success: function (response) {
                    console.log(response);
                    if (response.valid == '0') {
                        checkValidity.html('بررسی وضعیت لایسنس').attr('disabled', false);
                        checkValidityResponse.addClass('fsrs-error');
                        checkValidityResponse.text($("#fsrs-invalid-license").val());
                    } else if (response.valid == '1') {
                        checkValidity.html('بررسی وضعیت لایسنس').attr('disabled', false);
                        checkValidityResponse.addClass('fsrs-success');
                        checkValidityResponse.text($('#fsrs-valid-license').val());
                    }
                },
                error: function (error) {
                    checkValidity.html('بررسی وضعیت لایسنس').attr('disabled', false);
                    checkValidityResponse.addClass('fsrs-error');
                    checkValidityResponse.text(error);
                    console.log(error);
                }
            });
        });
    });
</script>