<?php

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * Class UI
 *
 * Render UI Components
 */
final class UI {
	private static $instance;

	public function __construct() {
	}

	public function render_toggle_switch( $label, $value, $name, $id = '' ) {
	    ?>
        <div class="row">
            <div class="col-sm-3"><?php esc_html_e( $label, 'full-schema' ); ?></div>
            <div class="col-auto">
                <label class="switch">
                    <input type="checkbox" id="<?php esc_attr_e( $name ); ?>"
						<?php if ( $value === '1' ): ?> checked="checked" <?php endif; ?>>
                    <span class="slider round"></span>
                </label>
            </div>
        </div>
        <input class="fsrs-toggle-<?php esc_attr_e( $name ); ?>" type="hidden" name="<?php esc_attr_e( $name ); ?>"
               value="<?php esc_attr_e( $value ); ?>">
        <script>
            jQuery(document).ready(function ($) {
                let inputEl = $('#<?php echo $name?>');
                let mainEl = $('.fsrs-toggle-<?php echo $name?>');
                inputEl.on('change', function (e) {
                    e.preventDefault();
                    if (inputEl.prop('checked')) {
                        mainEl.val('1');
                    }
                    if (!inputEl.prop('checked')) {
                        mainEl.val('0');
                    }
                })
            });
        </script>
		<?php
	}

	public function render_input(
		$label, $value, $name, $id = '', $type = 'text', $other_option = '',
		$extra_class = '' ) {
		?>
        <div class="row">
            <div class="col-8">
                <input type="<?php esc_attr_e( $type ); ?>" name="<?php esc_attr_e( $name ); ?>"
                       class="form-control fsrs-input-field <?php echo $extra_class ?>"
                       id="<?php esc_attr_e( $id ); ?>" value="<?php echo __(esc_html($value), 'full-schema') ?>"
					<?php echo $other_option ?>>
            </div>
        </div>
		<?php
	}

	public function render_textarea( $value, $name, $id = '' ) {
		?>
        <div class="row">
            <div class="col-8">
                <textarea type="text" name="<?php esc_attr_e( $name ); ?>"
                          class="form-control fsrs-input-field"
                          lines="3"
                          id="<?php esc_attr_e( $id ); ?>"><?php echo __(esc_html($value), 'full-schema') ?></textarea>
            </div>
        </div>
		<?php
	}

	public function render_select( $value, $name, $first_value, $second_value, $first_option_text,
        $second_option_text ) {
		?>
        <div class="row">
            <div class="col-sm-3">
                <select class="form-select form-select-lg mb-4" id="<?php esc_attr_e( $name ); ?>"
                        name="<?php esc_attr_e( $name ); ?>"
                        aria-label=".form-select-lg example" style="padding: 5px!important;">
                    <option value="<?php esc_attr_e( $first_value ); ?>" <?php if ( $value === $first_value ) {
					?>selected <?php } ?>><?php esc_html_e( $first_option_text,
							'full-schema' ); ?></option>
                    <option value="<?php esc_attr_e( $second_value ); ?>" <?php if ( $value === $second_value ) {
					?>selected <?php } ?>><?php esc_html_e( $second_option_text,
							'full-schema' ); ?></option>
                </select>
            </div>
        </div>
		<?php
	}

	/**
	 * @return mixed
	 */
	public static function getInstance(): UI {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;
	}
}