<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

final class TABS {
	private static $instance;

	public function __construct() {
		$this->init_tabs();
	}

	public function init_tabs() {
		$general_tabs     = $this->get_main_tabs();
		$useful_link_tabs = $this->get_useful_tab_links(); ?>
        <div class="container fsrs-setting-container">
            <div class="row">
                <div class="col-md-3">
                    <div class="fsrs-drawer-header sticky-top">
                        <nav class="nav nav-pills mb-3 flex-column nav-drawer" role="tab">
                            <a class="nav-link" href="#" tabindex="-1">
                                <img src="<?php echo FSRS_ADMIN_URL . 'image/full-schema.png' ?>"
                                     alt="full-schema" width="30" height="30"/>
                                <span class="fsrs-setting-header"><?php esc_html_e( 'فول اسکیما',
										'full-schema' ); ?></span>
                                <span class="fsrs-setting-text"
                                      style="float: left;"> <?php echo FULL_SCHEMA_RICH_SNIPPET_VERSION ?></span>
                            </a>
                        </nav>
                    </div>
                    <hr>
                    <h6 class="h6 drawer-heading"><?php esc_html_e( 'صفحات اصلی افزونه',
							'full-schema' ); ?></h6>
                    <div class="d-flex align-items-start">
                        <nav>
                            <div class="nav flex-column nav-pills me-1 fsrs-nav" id="nav-tab" role="tablist">
								<?php
								foreach ( $general_tabs as $tab ) :
									$class = ( $tab['id'] === '#dashboard' ) ? ' active' : '';
									$tab_id = $tab['id'] ?>
                                    <a class='nav-link<?php echo $class ?>' aria-current="page"
                                       href="<?php echo $tab_id ?>" data-bs-toggle="tab"
                                       data-bs-target="<?php echo $tab_id ?>" role="tab"
                                       aria-controls="<?php echo $tab_id ?>">
                                        <i class="<?php echo $tab['ic'] ?>"
                                           style="color: #4a4a48!important;"></i>
										<?php esc_html_e( $tab['title'], 'full-schema' ); ?>
                                    </a>
								<?php endforeach; ?>

                                <h6 class="h6 drawer-heading"><?php esc_html_e( 'وضعیت فعالسازی',
										'full-schema' ); ?></h6>
								<?php
								$valid = get_option( 'fsrs_pr_option' );
								if ( ! empty( $valid ) && $valid['valid'] === '1' ) :?>
                                    <a class='nav-link' aria-current="page"
                                       href="#activation" data-bs-toggle="tab"
                                       data-bs-target="#activation" role="tab"
                                       aria-controls="#activation" style="background: #78e08f66; color: #149a4b;">
                                        <i class="far fa-check-circle"
                                           style="color: #149a4b!important;"></i>
										<?php esc_html_e( "افزونه فعال است", 'full-schema' ); ?>
                                    </a>
								<?php else: ?>
                                    <a class='nav-link' aria-current="page"
                                       href="#activation" data-bs-toggle="tab"
                                       data-bs-target="#activation" role="tab"
                                       aria-controls="#activation" style="background: #ff475747; color: #c51e2c;">
                                        <i class="fas fa-ban"
                                           style="color: #c51e2c!important;"></i>
										<?php esc_html_e( "افزونه فعال نشده!", 'full-schema' ); ?>
                                    </a>
								<?php endif; ?>
                            </div>
                        </nav>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="tab-content" id="myTabContent">
                        <div class="tab-pane fade show active" id="dashboard" role="tabpanel"
                             aria-labelledby="dashboard-tab">
							<?php FSRS_TAB_DASHBOARD::get_instance() ?>
                        </div>
                        <div class="tab-pane fade" id="design" role="tabpanel" aria-labelledby="design-tab">
							<?php FSRS_TAB_DESIGN::get_instance() ?>
                        </div>
                        <div class="tab-pane fade" id="starsText" role="tabpanel" aria-labelledby="starsText-tab">
							<?php FSRS_TAB_STARS_TEXT::get_instance() ?>
                        </div>
                        <div class="tab-pane fade" id="tools" role="tabpanel" aria-labelledby="tools-tab">
							<?php FSRS_TAB_TOOLS::get_instance() ?>
                        </div>
                        <div class="tab-pane fade" id="marketing" role="tabpanel" aria-labelledby="marketing-tab">
							<?php FSRS_TAB_MARKETING::get_instance() ?>
                        </div>
                        <div class="tab-pane fade" id="activation" role="tabpanel"
                             aria-labelledby="activation-tab">
							<?php FSRS_TAB_ACTIVATION::getInstance() ?>
                        </div>
                        <div class="tab-pane fade" id="updates" role="tabpanel"
                             aria-labelledby="updates-tab">
							<?php FSRS_TAB_UPDATES::getInstance() ?>
                        </div>
                    </div>
                </div>
                <script>
                    jQuery(document).ready(function ($) {
                        $(".nav-tabs a").click(function () {
                            $(this).tab('show');
                        });

                    });
                </script>
            </div>
        </div>
		<?php
	}

	public function get_main_tabs(): array {
		return array(
			array(
				'ic'    => 'fas fa-home',
				'title' => __( 'داشبورد', 'full-schema' ),
				'id'    => '#dashboard'
			),
			array(
				'ic'    => 'fas fa-paint-brush',
				'title' => __( 'طراحی', 'full-schema' ),
				'id'    => '#design'
			),
			array(
				'ic'    => 'fas fa-font',
				'title' => __( 'متن ستاره‌ها', 'full-schema' ),
				'id'    => '#starsText'
			),
			array(
				'ic'    => 'fas fa-mail-bulk',
				'title' => __( 'سئو و مارکتینگ', 'full-schema' ),
				'id'    => '#marketing'
			),
			array(
				'ic'    => 'fas fa-toolbox',
				'title' => __( 'ابزارها', 'full-schema' ),
				'id'    => '#tools'
			),
			array(
				'ic'    => 'fas fa-key',
				'title' => __( 'فعالسازی', 'full-schema' ),
				'id'    => '#activation'
			),
			array(
				'ic'    => 'fas fa-history',
				'title' => __( 'آپدیت‌ها', 'full-schema' ),
				'id'    => '#updates'
			),
		);
	}

	public function get_useful_tab_links(): array {
		return array(
			array(
				'ic'    => 'fas fa-gift',
				'title' => __( 'دوره رایگان سئو', 'full-schema' ),
				'url'   => 'https://safine.net/seo-course/beginners-free-training/'
			),
		);
	}

	public static function get_instance(): TABS {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}
}