<?php
/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
final class FSRS_TAB_TOOLS {
    private static $instance;

	public function __construct() {
		$this->init_view();
	}

	public function init_view( ) {
		ob_start();
		$this->import_from_other_plugins();
		$this->reset_plugin();
		$this->debug_fsrs(); ?>
		<?php
		echo ob_get_clean();
	}

	public function import_from_other_plugins() {
		?>
        <div class="fsrs-alert-container">
            <h3 class="fsrs-setting-box" id="fsrs-setting-rating" onclick="hideParentChild('fsrs-ifop')">
                <span class="dashicons dashicons-admin-customizer"></span>
				<?php esc_html_e( 'درون ریزی از پلاگین‌های دیگر', 'full-schema' ); ?>
            </h3>

            <div class="container fsrs-alert-container-item fsrs-alert-container" id="fsrs-ifop"
                 style="margin-bottom: 32px; border-right: 3px solid #58e0d4!important;">
				<?php
				if ( ! function_exists( 'kksr_freemius' ) &&  ! class_exists( 'Rate_My_Post_Public' ) &&
				     ! function_exists( 'yasr_fs' ) )  {
					?>
                    <div class="row ifop-container">
                        <p style="font-size: 14px;"><em><?php esc_html_e( 'پلاگینی برای درون‌ریزی وجود ندارد!',
									'full-schema' ); ?></em></p>
                    </div>
					<?php
				}
				if ( function_exists( 'kksr_freemius' ) ) {
					?>
                    <div class="row ifop-container">
                        <div class="col-sm-3"><p class="fsrs-ifop-label"><?php
								esc_html_e( 'درون ریزی از افزونه kkstar', 'full-schema' ); ?></p></div>
                        <div class="col">
                            <button class="btn btn-sm btn-primary" id="fsrs-kk-import"
                                    nonce="<?php echo wp_create_nonce( 'fsrs_import_from_other_plugin_settings' )
							        ?>"><?php esc_html_e( 'شروع عملیات
                            ', 'full-schema' ); ?></button>
                        </div>
                    </div>
					<?php
				} ?>
				<?php if ( class_exists( 'Rate_My_Post_Public' ) ): ?>
                    <div class="row ifop-container">
                        <div class="col-sm-3"><p class="fsrs-ifop-label"><?php
								esc_html_e( 'درون ریزی از افزونه rate my post', 'full-schema' ); ?></p></div>
                        <div class="col">
                            <button class="btn btn-sm btn-primary" id="fsrs-rmp-import"
                                    nonce="<?php echo wp_create_nonce( 'fsrs_import_from_other_plugin_settings' )
							        ?>"><?php esc_html_e( 'شروع عملیات', 'full-schema' ); ?></button>
                        </div>
                    </div>
				<?php endif ?>
	            <?php if ( function_exists( 'yasr_fs' )): ?>
                    <div class="row ifop-container">
                        <div class="col-sm-3"><p class="fsrs-ifop-label"><?php
					            esc_html_e( 'درون ریزی از افزونه yasr', 'full-schema' ); ?></p></div>
                        <div class="col">
                            <button class="btn btn-sm btn-primary" id="fsrs-yasr-import"
                                    nonce="<?php echo wp_create_nonce( 'fsrs_import_from_other_plugin_settings' )
				                    ?>"><?php esc_html_e( 'شروع عملیات ', 'full-schema' ); ?></button>
                        </div>
                    </div>
	            <?php endif ?>
            </div>
        </div>
		<?php
	}

	public function reset_plugin() {
		?>
        <div class="fsrs-alert-container">
            <h3 class="fsrs-setting-box" id="fsrs-setting-rating" onclick="hideParentChild('reset-settings-container')">
                <span class="dashicons dashicons-admin-tools"></span>
				<?php esc_html_e( 'راه‌اندازی مجدد فول اسکیما', 'full-schema' ); ?>
            </h3>
            <div id="reset-settings-container">
                <p style="font-size: 17px; color: #ff2b00; font-weight: bold; margin-top: 24px">
					<?php
					esc_html_e( '*اخطار! با راه‌اندازی مجدد،
                     تمام تنظیمات افزونه و تغییرات شما به حالت اولیه باز می‌گردند.*', 'full-schema' ); ?>
                </p>
                <div style="display: inline-block; margin-bottom: 16px">
                    <button class="btn btn-primary btn-reset-plugin btn-danger" id="btn-reset-plugin"
                            style="margin-bottom: 16px"
                            type="button"><?php esc_html_e( 'راه‌اندازی مجدد', 'full-schema' ); ?>
                    </button>
                </div>
            </div>
        </div>
        <input class="fsrs-reset-thank-text" type="hidden" value="<?php
		esc_html_e( 'تنظیمات افزونه به حالت اولیه بازگشت.', 'full-schema' ); ?>">
        <input type="hidden" id="fsrs_reset_settings_nonce"
               value="<?php esc_attr_e(wp_create_nonce( 'fsrs-reset-nonce' )); ?>">
		<?php
	}

	public function debug_fsrs() {
		error_reporting( E_ALL );
		$active_theme = wp_get_theme();
		global $wp_version;
		$allPlugins     = get_plugins();
		$active_plugins = get_option( 'active_plugins', '' );
		$plugin_res     = array(); ?>
        <div class="fsrs-alert-container">
            <h3 class="fsrs-setting-box" id="fsrs-setting-rating">
                <span class="dashicons dashicons-admin-tools"></span>
				<?php esc_html_e( 'خطایابی افزونه', 'full-schema' ); ?>
            </h3>
            <div class="container fsrs-debug-container">
                <div class="row">
                    <div class="form-group">
                        <p class="p-2" for="fsrs-debug" style="font-size: 17px; color: #ec5737; font-weight: bold">
							<?php esc_html_e(
								' زمانی که مسئول پشتیبانی از شما درخواست کرد این متن را کپی کنید و بفرستید',
								'full-schema' ); ?>
                        </p>
                        <textarea class="form-control d-flex justify-content-end" name="fsrs-debug" id="fsrs-debug"
                                  readonly><?php
							foreach ( $allPlugins as $key => $value ) {
								if ( in_array( $key, $active_plugins, true ) ) { // display active only
									$plugin_res[] = array(
										'plugin_name' => $value['Name'],
										'version'     => $value['Version']
									);
								}
							}
							echo json_encode( array(
								'wp_version'      => $wp_version,
								'php_version'     => PHP_VERSION,
								'wp_debug'        => WP_DEBUG,
								/**
								 * when you use a child theme,
								 * maybe you rename it. so we must to know your theme name for debugging.
								 */
								'all_themes'      => wp_get_themes(),
								'active_theme'    => esc_html( $active_theme->get( 'TextDomain' ) ),
								'theme_uri'       => get_theme_file_path(),
								'active_plugins'  => $plugin_res,
								'fsrs-version'    => FULL_SCHEMA_RICH_SNIPPET_VERSION,
								'host'            => FSRS_COMMON::get_instance()->get_host(),
								'customer_option' => get_option( 'fsrs_pr_option', '' ),
								'post_types'      => get_post_types()
							) )
							?>
                        </textarea>
                    </div>
                </div>
            </div>
        </div>
		<?php
	}

	public static function get_instance(): FSRS_TAB_TOOLS {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}
}