<?php

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}
final class FSRS_TAB_DESIGN {
	private static $instance;

	public function __construct() {
		ob_start();
		$this->init_design_settings();
		echo ob_get_clean();
	}

	public function init_design_settings() {
		$design_settings = get_option( DESIGN_OPTION_NAME,
            FULL_SCHEMA_RICH_SNIPPET_SETTINGS::design_def_settings() );
		?>
        <div class="fsrs-alert-container">
            <h3 class="fsrs-setting-box" id="fsrs-setting-rating" onclick="hideParentChild('fsrs-admin-form1')">
                <span class="fas fa-paint-brush" style="color:#f16334; margin-left: 12px!important;"></span>
				<?php esc_html_e( 'تغییر ظاهر ستاره‌ها', 'full-schema' ); ?>
            </h3>
            <div id="fsrs-admin-form1">
                <div class="fsrs-alert-container-item fsrs-alert-container"
                     style="margin-bottom: 12px; padding-bottom: 12px; border-right: 3px solid #ffbd5b;">
                    <form class="form" id="fsrs_setting_form" action="#" enctype="multipart/form-data">
                        <div class="container">
                            <div class="row">
                                <table class="form-table">
                                    <tbody>
									<?php
									$fields = $this->get_design_fields();
									foreach ( $fields as $field ):
										$field_name = $field['name'];
										if ( is_null( $design_settings[ $field_name ] ) ) {
											$default_setting = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::design_def_settings();
											$value           = $default_setting[ $field_name ];
										} else {
											$value = $design_settings[ $field_name ];
										}
										?>
                                        <tr>
                                            <th scope="row">
												<?php esc_html_e( $field['title'], 'full-schema' ); ?>
                                            </th>
                                            <td class="align-middle">
												<?php
												if ( $field['field_type'] === 'switch' ) :
													UI::getInstance()->render_toggle_switch( $field['title'], $value, $field_name );
                                                elseif ( $field['field_type'] === 'input' ):
													UI::getInstance()->render_input( $field['title'],
                                                        __(esc_html($value), 'full-schema'),
														$field_name,
														$field_name, $field['type'], $field['options'],
														$field['class'] );
                                                elseif ( $field['field_type'] === 'textarea' ):
													UI::getInstance()->render_textarea( $value, $field_name, $field_name );
                                                elseif ( $field['field_type'] === 'select' ):
													UI::getInstance()->render_select( $value, $field_name,
														$field['first_value'], $field['second_value'],
														$field['first_option_text'], $field['second_option_text'] );
												endif; ?>
                                                <div class="fsrs-field-helper-text">
                                                    <p><?php esc_html_e( $field['help_text'], 'full-schema' ); ?></p>
                                                </div>
                                            </td>
                                        </tr>
									<?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="fixed-bottom" style="right: auto!important;margin-bottom: 32px;margin-left: 32px;">
                            <button class="btn btn-primary" style="margin-top: 16px"
                                    id="fsrs-settings-save"><?php esc_html_e( 'ثبت تغییرات',
									'full-schema' ); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
		<?php
	}

	public function get_design_fields(): array {
		return array(
			array(
				'title'      => __( 'اندازه ستاره بالا', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_st_up_star_size' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'با تغییر مقدار این فیلد، 
				اندازه ستاره‌ای که قبل از محتوا نشان داده می‌شود را می‌توانید تغییر دهید', 'full-schema' ),
				'type'       => esc_attr( 'number' ),
				'options'    => 'min="12" max="40"',
				'class'      => ''
			),
			array(
				'title'      => __( 'اندازه ستاره پایین', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_st_down_star_size' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'با تغییر مقدار این فیلد، 
				اندازه ستاره‌ای که در انتهای محتوای صفحه نشان داده می‌شود را می‌توانید تغییر دهید', 'full-schema' ),
				'type'       => esc_attr( 'number' ),
				'options'    => 'min="12" max="40"',
				'class'      => ''
			),
			array(
				'title'              => __( 'جهت ستاره‌ها', 'full-schema' ),
				'name'               => esc_attr( 'fsrs_star_direction' ),
				'field_type'         => esc_attr( 'select' ),
				'help_text'          => __( 'می‌توانید مشخص کنید که جهت ستاره‌ها از کدام سمت باشد.', 'full-schema' ),
				'first_value'        => 'rtl',
				'second_value'       => 'ltr',
				'first_option_text'  => 'راست به چپ',
				'second_option_text' => 'چپ به راست',
			),
			array(
				'title'      => __( 'ستاره بالا در برگه نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_page_st_up_star_show' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'با تغییر وضعیت این گزینه می‌توانید مشخص کنید که ستاره قبل از محتوا در برگه‌های
				شما نمایش داده شود یا خیر.', 'full-schema' )
			),
			array(
				'title'      => __( 'ستاره بالا در نوشته‌ها نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_post_st_up_star_show' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'با تغییر وضعیت این گزینه می‌توانید مشخص کنید که ستاره قبل از محتوا در نوشته‌های
				شما نمایش داده شود یا خیر.', 'full-schema' )
			),
			array(
				'title'      => __( 'رنگ ستاره‌ها', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_normal_color' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'رنگ ستاره‌ها در وضعیت نرمال. پیشفرض #FFD700', 'full-schema' ),
				'type'       => esc_attr( 'text' ),
				'options'    => '',
				'class'      => 'fsrs-color-input'
			),
			array(
				'title'      => __( 'رنگ پس زمینه ستاره‌های پایین', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_st_down_bg_color' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'با استفاده از این گزینه می‌توانید رنگ پس زمینه 
				ستاره‌های پایین و بالا را تغییر دهید. پیشفرض #FFFFFF',
					'full-schema' ),
				'type'       => esc_attr( 'text' ),
				'options'    => '',
				'class'      => 'fsrs-color-input'
			),
			array(
				'title'      => __( 'رنگ ستاره پس از کلیک', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_rated_color' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'پس از کلیک کاربر برای ثبت رای این رنگ روی ستاره‌ها اعمال می‌شود. پیشفرض #FFD700',
					'full-schema' ),
				'type'       => esc_attr( 'text' ),
				'options'    => '',
				'class'      => 'fsrs-color-input'
			),
			array(
				'title'      => __( 'رنگ ستاره در حالت hover', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_hover_color' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'زمانی که کاربر موس خود را روی ستاره‌ها می‌برد
				 این رنگ نمایش داده می‌شود. پیشفرض #FFD700', 'full-schema' ),
				'type'       => esc_attr( 'text' ),
				'options'    => '',
				'class'      => 'fsrs-color-input'
			),
			array(
				'title'      => __( 'رنگ پس‌زمینه کادر', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_st_down_frame_bg_color' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'رنگ پس‌زمینه کادر پایین پیشفرض #FFFFFF', 'full-schema' ),
				'type'       => esc_attr( 'text' ),
				'options'    => '',
				'class'      => 'fsrs-color-input'
			),
			array(
				'title'      => __( 'رنگ دور کادر', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_st_down_border_color' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'رنگ دور کادر ستاره‌های پایین. پیشفرض #E2E1E1', 'full-schema' ),
				'type'       => esc_attr( 'text' ),
				'options'    => '',
				'class'      => 'fsrs-color-input'
			),
			array(
				'title'      => __( 'رنگ متن‌های زیر ستاره', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_st_down_texts_color' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'رنگ تمامی متن‌هایی که زیر ستاره به نمایش در می‌آیند.',
					'full-schema' ),
				'type'       => esc_attr( 'text' ),
				'options'    => '',
				'class'      => 'fsrs-color-input'
			),
			array(
				'title'      => __( 'متن تشکر', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_st_down_thanks_text' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( esc_html( 'متنی که پس از ثبت رای نمایش داده می‌شود.' ), 'full-schema' ),
				'type'       => esc_attr( 'text' ),
				'options'    => '',
				'class'      => ''
			),
			array(
				'title'      => __( 'اندازه فونت متن‌های زیر ستاره', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_st_down_font_size' ),
				'field_type' => esc_attr( 'input' ),
				'help_text'  => __( 'با تغییر مقدار این فیلد می‌توانید 
				فونت متن‌هایی که زیر ستاره‌های پایین نمایش داده می‌شوند را کوچک یا بزرگ کنید.', 'full-schema' ),
				'type'       => esc_attr( 'number' ),
				'options'    => 'min="5" max="50"',
				'class'      => ''
			),
			array(
				'title'      => __( 'آیا انیمیشن بارگذاری بعد از کلیک نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_show_progress' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'در صورت فعال بودن، پس از کلیک برای ثبت رای، 
				یک انیمیشن لودینگ برای کاربر به نمایش در میاید.', 'full-schema' )
			),
			array(
				'title'      => __( 'تعداد آرا نمایش داده شود؟', 'full-schema' ),
				'name'       => esc_attr( 'fsrs_show_number_of_votes' ),
				'field_type' => esc_attr( 'switch' ),
				'help_text'  => __( 'در صورت فعال بودن، تعداد آرا زیر ستاره‌ها نمایش داده می‌شود.', 'full-schema' )
			),
			array(
				'title'              => __( 'حالت ستاره', 'full-schema' ),
				'name'               => esc_attr( 'fsrs_star_shape' ),
				'field_type'         => esc_attr( 'select' ),
				'help_text'          => __( 'با استفاده از این گزینه می‌توانید شکل ستاره‌ها را مشخص کنید.', 'full-schema' ),
				'first_value'        => 'straight',
				'second_value'       => 'rounded',
				'first_option_text'  => 'تیز',
				'second_option_text' => 'گرد',
			),

		);
	}

	public static function get_instance(): FSRS_TAB_DESIGN {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}

}