<?php

class FSRS_RATING_VIEW {

	public function __construct() {
		$valid = get_option( 'fsrs_pr_option' );
		if ( ! empty( $valid ) && $valid['valid'] == '1' ) {
			add_action( 'wp_head', [ $this, 'print_schema' ] );
			add_action( 'wp_footer', [ $this, 'addFooterScript' ] );
		}
		add_filter( 'the_content', [ $this, 'initPostRatingCallback' ] );
	}

	public function print_schema() {
		FSRS_ADMIN::printRatingSchema();
		FSRS_ADMIN::addHeaderScript();
	}

	public function addFooterScript() {
		$fsrs_script = get_post_meta( get_the_ID(), '_fsrs_script', true );
		! isset( $fsrs_script['footer'] ) ? [ '' ] : $fsrs_script['footer'];
		FSRS_ADMIN::printFAQSchema();
	}

	public function initPostRatingCallback( $content ) {

		if ( is_singular( 'product' ) && is_home() ) {
			return $content;
		}
		if ( is_singular( 'post' ) ) {
			return $this->showRating( $content );
		}
		if ( get_post_type() == 'page' ) {
			$result = get_post_meta( get_the_ID(), '_fsrs_page_star_option', true );
			if ( ! empty( $result ) && $result['showOption'] == '1' ) {
				return $this->showRating( $content );
			} else {
				return $content;
			}
		}

		return $content;
	}

	public function showRating( $content ) {

		$post_id = get_the_ID();
		$this->enqueueStyle();

		$def_settings  = get_option( 'fsrs_def_settings', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::settings_default() );
		$live_rating_font_size = $def_settings['fsrs_st_down_font_size'];
		if ( $def_settings['fsrs_st_up_star_show'] == '1' ) {
			$pre_con =
				'
				 <div class="my-rating-top" id="rating-top" style="text-align: center; direction: rtl"></div>
				';
		}
		$after_con =
			'
				 <div class="my-rating" id="fsrs-rating" style="text-align: center; direction: rtl">
				 </div>
				 <div style="text-align: center; margin-top: 10px;">
				 <span class="rating-hov-text fsrs-h2"></span>				 	
				 </div>
				 <div class="live-rating fsrs-h4" style="text-align: center; margin-top: 10px; 
				 font-size: '.$live_rating_font_size.'px">
				 </div>
				 <div class="live-rating-count fsrs-h4" style="text-align: center; margin-top: 10px; 
				 font-size: '.$live_rating_font_size.'px">
				 </div>
				';
		?>
        <input type="hidden" id="post-id" value="<?php echo $post_id ?>">
		<?php
		return $pre_con . $content . $after_con;
	}

	public function enqueueStyle() {
		wp_enqueue_style( 'fsrs_rating_css', FSRS_CSS_DIR . 'star-rating-svg.css' );
		wp_enqueue_script( 'fsrs_star_lib_script', FSRS_JS_DIR . 'jquery.star-rating-svg.js',
			'jquery', '', false );

		wp_register_script( 'fsrs_main_script', FSRS_JS_DIR . 'main.js', array( 'jquery' ),
			'', false );
		$nonce = wp_create_nonce( "fsrs_nonce" );
		wp_localize_script( 'fsrs_main_script', 'fsrs_object', array(
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'_wpnonce' => $nonce
		) );
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'fsrs_main_script' );
	}


}
