<?php

/**
* @wordpress-plugin
* Plugin Name: فول اسکیما ریچ اسنیپت
* Plugin URI: https://safine.net
* Description: افزونه قدرتمند و کاملا ایرانی برای نشانه دار شدن صفحات سایت در نتایج جستجو با ستاره و سوال و جواب. به همراه امکان تزریق کد دلخواه به هدر و فوتر صفحات
* Version: 1.2.2
* Author: آکادمی سفینه (مهدی محمدی)
* Author URI: https://safine.net
* License: GPLv2 or later
*/

//Abort Direct Call Plugin
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'no-Access' );
}

// Plugin version
define( 'FULL_SCHEMA_RICH_SNIPPET_VERSION', '1.2.2' );

//define necessary directories path
define( 'FSRS_DIR', plugin_dir_path( __FILE__ ) );
define( 'FSRS_URL', plugin_dir_url( __FILE__ ) );
define( 'FSRS_INC_DIR', trailingslashit( FSRS_DIR . 'includes' ) );
define( 'FSRS_ADMIN_DIR', trailingslashit( FSRS_DIR . 'admin' ) );
define( 'FSRS_ADMIN_URL', trailingslashit( FSRS_URL . 'admin' ) );
define( 'FSRS_COMMON_DIR', trailingslashit( FSRS_DIR . 'common' ) );
define( 'FSRS_ASSETS_DIR', trailingslashit( FSRS_URL . 'assets' ) );
define( 'FSRS_JS_DIR', trailingslashit( FSRS_ASSETS_DIR . 'js' ) );
define( 'FSRS_IMAGES_DIR', trailingslashit( FSRS_ASSETS_DIR . 'images' ) );
define( 'FSRS_CSS_DIR', trailingslashit( FSRS_ASSETS_DIR . 'css' ) );

//register activate hook
register_activation_hook( __FILE__, 'fsrs_activation_hook' );

//register activate hook
register_deactivation_hook( __FILE__, 'fsrs_deactivation_hook' );

include FSRS_COMMON_DIR . 'class-fsrs-settings.php';
//register activation function
function fsrs_activation_hook() {
	require_once FSRS_INC_DIR . 'class-fsrs-activator.php';
	fsrs_Activator::activate();
}

//register de-activation function
function fsrs_deactivation_hook() {
	require_once FSRS_INC_DIR . 'class-fsrs-deactivator.php';
	fsrs_De_Activator::deActivate();
}

//plugin functions class
require plugin_dir_path( __FILE__ ) . 'common/fsrs-dev-functions.php';

//core plugin class
require FSRS_INC_DIR . 'class-fsrs-init.php';

//run and execute fsrs function
function execute_fsrs() {
	$plugin = new fsrs_INIT();
	$plugin->run();
}
execute_fsrs();

