<?php

//add action when ajax action call
add_action('wp_ajax_savePostData', 'fsrs_submit_callback');
add_action('wp_ajax_nopriv_savePostData', 'fsrs_submit_callback');

add_action('wp_ajax_getPostData', 'fsrs_get_star_options');
add_action('wp_ajax_nopriv_getPostData', 'fsrs_get_star_options');

add_action('wp_ajax_fsrs_activate', 'fsrs_activation_callback');
add_action('wp_ajax_nopriv_fsrs_activate', 'fsrs_activation_callback');

add_action('wp_ajax_fsrs_reset', 'fsrs_reset_callback');
add_action('wp_ajax_nopriv_fsrs_reset', 'fsrs_reset_callback');

add_action('wp_ajax_fsrs_check_validity', 'fsrs_check_validity_callback');
add_action('wp_ajax_nopriv_fsrs_check_validity', 'fsrs_check_validity_callback');

add_action('wp_ajax_fsrs_get_rating_settings', 'fsrs_get_rating_settings');
add_action('wp_ajax_nopriv_fsrs_get_rating_settings', 'fsrs_get_rating_settings');

add_action('wp_ajax_fsrs_save_rating_settings', 'fsrs_save_rating_settings');
add_action('wp_ajax_nopriv_fsrs_save_rating_settings', 'fsrs_save_rating_settings');

add_action('wp_ajax_fsrs_save_star_texts', 'fsrs_save_star_texts');
add_action('wp_ajax_nopriv_fsrs_save_star_texts', 'fsrs_save_star_texts');

add_action('wp_ajax_fsrs_set_notif_read', 'fsrs_set_notif_read');
add_action('wp_ajax_nopriv_fsrs_set_notif_read', 'fsrs_set_notif_read');

//submit star ratings
function fsrs_submit_callback()
{
    //check nonce
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs_nonce")) {
        $p_id = isset($_POST['fsrsPostId']) ? $_POST['fsrsPostId'] : 0;
        $post_rating = intval($_POST['pRating']);

        //get cookie
        $ratingCookie = isset($_COOKIE['_fsrs_rating']) ? unserialize(base64_decode($_COOKIE['_fsrs_rating']))
            : array();

        if (!$ratingCookie) {
            $ratingCookie = array();
        }

        //check user Already rated or not
        if (!in_array($p_id, $ratingCookie)) {
            $new_post_data = $post_rating;
            $result = add_post_meta($p_id, '_fsrs_rating', $new_post_data);

            global $wpdb;

            $sql = "SELECT avg(meta_value) AS rating, count(meta_value) 'count'
                    FROM {$wpdb->prefix}postmeta WHERE  meta_key = '_fsrs_rating' 
                    AND post_id = '$p_id'";

            $rating_live_values = $wpdb->get_results($sql, 'ARRAY_A');
            $rating = '0';
            $seen_count = '0';
            foreach ($rating_live_values as $row) {
                $rating = round($row['rating'], 1, PHP_ROUND_HALF_UP);
                $seen_count = $row['count'];
            }

            if ($result) {
                echo json_encode(array(
                    'result' => 'success',
                    'ratingCount' => str_replace(['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'], [
                        '۰',
                        '۱',
                        '۲',
                        '۳',
                        '۴',
                        '۵',
                        '۶',
                        '۷',
                        '۸',
                        '۹',
                    ],
                        $seen_count),
                    'ratingValue' => strval($rating),
                    'faRatingDigit' => str_replace(['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'], [
                        '۰',
                        '۱',
                        '۲',
                        '۳',
                        '۴',
                        '۵',
                        '۶',
                        '۷',
                        '۸',
                        '۹',
                    ],
                        $rating)
                ));
            } else {
                echo json_encode(array('result' => 'error'));
            }

            $ratingCookie[] = $p_id;
            $expire = time() + 30 * DAY_IN_SECONDS;
            setcookie('_fsrs_rating', base64_encode(serialize($ratingCookie)), $expire, COOKIEPATH, COOKIE_DOMAIN);
            $_COOKIE['_fsrs_rating'] = base64_encode(serialize($ratingCookie));
        } else {
            echo json_encode(array('result' => 'error'));
        }
    }
    wp_die();
}

//return star options
function fsrs_get_star_options()
{
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs_nonce")) {
        $p_id = isset($_POST['fsrsPostId']) ? $_POST['fsrsPostId'] : 0;
        global $wpdb;
        $seen_count = '0';
        $rating = '0';

        $sql = "SELECT avg(meta_value) AS rating, count(meta_value) 'count'
                    FROM {$wpdb->prefix}postmeta WHERE  meta_key = '_fsrs_rating' 
                    AND post_id = '$p_id'";

        $result = $wpdb->get_results($sql, 'ARRAY_A');

        foreach ($result as $row) {
            $rating = round($row['rating'], 1, PHP_ROUND_HALF_UP);

            $seen_count = $row['count'];
        }
        if ($rating == '0') {
            add_post_meta($p_id, '_fsrs_rating', 5);
            $rating = '5';
            $seen_count = '1';
        }

        if (!empty($result)) {
            echo json_encode(array(
                'result' => 'success',
                'ratingValue' => strval($rating),
                'faDigitValue' => str_replace(['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'], [
                    '۰',
                    '۱',
                    '۲',
                    '۳',
                    '۴',
                    '۵',
                    '۶',
                    '۷',
                    '۸',
                    '۹'
                ],
                    $rating),
                'faDigitCount' => str_replace(['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'], [
                    '۰',
                    '۱',
                    '۲',
                    '۳',
                    '۴',
                    '۵',
                    '۶',
                    '۷',
                    '۸',
                    '۹'
                ],
                    $seen_count)
            ));
        }

    }
    wp_die();
}

function fsrs_activation_callback()
{
//    check_ajax_referer('fsrs-activation-nonce', 'nonce');
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs-activation-nonce")) {
        $license_key = $_POST['licenseKey'];
        if (empty($license_key)) {
            $license_key = '';
            echo json_encode(array('result' => '0'));
            wp_die();
        }

        require FSRS_ADMIN_DIR . 'lib/class-fsrs-zhaket-api.php';
        $activation_result = Fsrs_Zhaket_License::install($license_key, FULL_SCHEMA_RICH_SNIPPET_SETTINGS::$token);
        if ($activation_result->status === 'successful') {
            update_option('fsrs-pr-license', (string)$license_key, true);
            update_option('fsrs_pr_option', array('license' => (string)$license_key, 'valid' => '1'),
                true);
            echo json_encode(array('result' => '1'));
        } else {
            echo json_encode(array('result' => '0'));
        }
    } else {
        echo 'nonce is invalid!';
    }
    wp_die();
}

function fsrs_reset_callback()
{
    check_ajax_referer('fsrs-reset-nonce', 'nonce');
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs-reset-nonce")) {
        delete_post_meta_by_key('_fsrs_schema');
        delete_post_meta_by_key('_fsrs_script');
        delete_post_meta_by_key('_fsrs_faq_schema');
        delete_post_meta_by_key('_fsrs_rating');
        delete_option('fsrs_def_settings');
        delete_option('fsrs_star_texts');
        delete_post_meta_by_key('_fsrs_page_star_option');
        echo json_encode(array('code' => '1'));
    } else {
        echo 'nonce is invalid';
    }
    wp_die();
}

function fsrs_check_validity_callback()
{
    check_ajax_referer('fsrs-check-validity-nonce', 'nonce');
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs-check-validity-nonce")) {
        $pr_license = get_option('fsrs-pr-license');
        if (!empty($pr_license)) {
            require FSRS_ADMIN_DIR . 'lib/class-fsrs-zhaket-api.php';
            $res = Fsrs_Zhaket_License::isValid($pr_license);
            if (!($res->status === 'successful')) {
                update_option('fsrs_pr_option', array('license' => $pr_license, 'valid' => '0'));
                echo json_encode(array('valid' => '0'));
            } else if ($res->status === 'successful') {
                update_option('fsrs_pr_option', array('license' => $pr_license, 'valid' => '1'));
                echo json_encode(array('valid' => '1'));
            }
        } else {
            echo json_encode(array('valid' => '0'));
        }
    } else {
        echo json_encode(array('valid' => 'nonce not valid'));
    }
    wp_die();
}

function fsrs_get_rating_settings()
{
    check_ajax_referer('fsrs_nonce', 'nonce');
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs_nonce")) {
//		require FSRS_COMMON_DIR . 'class-fsrs-settings.php';
        $ratings_setting = get_option('fsrs_def_settings', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::settings_default());
        $star_text = get_option('fsrs_star_texts', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::star_texts());
        get_option('fsrs_star_texts', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::star_texts());
        echo json_encode(array(
            'result' => 'success',
            'fsrs_st_up_star_size' => $ratings_setting['fsrs_st_up_star_size'],
            'fsrs_st_down_star_size' => $ratings_setting['fsrs_st_down_star_size'],
            'fsrs_st_up_star_show' => $ratings_setting['fsrs_st_up_star_show'],
            'fsrs_st_down_thanks_text' => $ratings_setting['fsrs_st_down_thanks_text'],
            'star1' => $star_text['star1'],
            'star2' => $star_text['star2'],
            'star3' => $star_text['star3'],
            'star4' => $star_text['star4'],
            'star5' => $star_text['star5'],
        ));
    } else {
        echo json_encode(array('result' => 'failed'));
    }
    wp_die();
}

function fsrs_save_rating_settings()
{
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs_admin_nonce")) {
        $fsrs_st_up_star_size = $_POST['fsrs_st_up_star_size'];
        $fsrs_st_down_star_size = $_POST['fsrs_st_down_star_size'];
        $fsrs_st_up_star_show = $_POST['fsrs_st_up_star_show'];
        $fsrs_st_down_thanks_text = $_POST['fsrs_st_down_thanks_text'];
        $fsrs_st_down_font_size = $_POST['fsrs_st_down_font_size'];
        $result = array(
            'fsrs_st_up_star_size' => $fsrs_st_up_star_size,
            'fsrs_st_down_star_size' => $fsrs_st_down_star_size,
            'fsrs_st_up_star_show' => $fsrs_st_up_star_show,
            'fsrs_st_down_thanks_text' => $fsrs_st_down_thanks_text,
            'fsrs_st_down_font_size' => $fsrs_st_down_font_size
        );
        update_option('fsrs_def_settings', $result);
        echo json_encode(array('code' => '110'));
    } else {
        echo 'nonce is invalid';
    }
    wp_die();
}

function fsrs_save_star_texts()
{
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs_admin_nonce")) {
        $fsrs_star1 = $_POST['fsrs_star1'];
        $fsrs_star2 = $_POST['fsrs_star2'];
        $fsrs_star3 = $_POST['fsrs_star3'];
        $fsrs_star4 = $_POST['fsrs_star4'];
        $fsrs_star5 = $_POST['fsrs_star5'];

        $result = array(
            'star1' => $fsrs_star1,
            'star2' => $fsrs_star2,
            'star3' => $fsrs_star3,
            'star4' => $fsrs_star4,
            'star5' => $fsrs_star5
        );
        update_option('fsrs_star_texts', $result);
        echo json_encode(array('code' => '110'));
    } else {
        echo 'nonce is invalid!';
    }
    wp_die();
}

function fsrs_set_notif_read()
{
    if (wp_verify_nonce($_REQUEST['nonce'], "fsrs_admin_nonce")) {
        $notif = $_POST['content'];
        update_option('fsrs_notif_option',
            array('notif_content' => str_replace('\\', '', $notif)));
        echo json_encode(array(
            'code' => '110'
        ));
    } else {
        echo 'nonce is invalid';
    }
    wp_die();
}