<?php

class FULL_SCHEMA_RICH_SNIPPET_SETTINGS {

	public static $token = '718e8b68-ec39-474f-9458-066f8847acaa';

	public static function default_options( $post_id, $title, $rating = array()) {
		if (!isset($rating)) $rating = '';
		return array(
			'@context'        => 'https://schema.org/',
			'@type'           => 'MediaObject',
			'uploadDate'      => mysql2date( 'Y-m-d', get_post( $post_id )->post_date_gmt, false ),
			'name'            => $title,
			'aggregateRating' => $rating
		);
	}

	public static function video_object_options( $postId, $title, $desc, $time, $contentUrl, $rating = array()) {
		if (!isset($rating)) $rating = '';
		$thumbnail = '';
		if (!get_the_post_thumbnail($postId) == false) {
			$thumbnail = get_the_post_thumbnail_url($postId);
		}
		return array(
			'@context'        => 'https://schema.org/',
			'@type'           => 'VideoObject',
			'name'            => $title,
			'description'     => $desc,
			'duration'        => $time,
			'thumbnailUrl'    => $thumbnail,
			'uploadDate'      => mysql2date( 'Y-m-d', get_post( $postId )->post_date_gmt, false ),
			'contentUrl'      => $contentUrl,
			'aggregateRating' => $rating
		);
	}

	public static function audio_object_options( $duration, $title, $desc, $contentUrl, $rating = array()) {
		if (!isset($rating)) $rating = '';
		return array(
			'@context'        => 'https://schema.org/',
			'@type'           => 'AudioObject',
			'contentUrl'      => $contentUrl,
			'description'     => $desc,
			'duration'        => $duration,
			'encodingFormat'  => 'audio/mpeg',
			'name'            => $title,
			'aggregateRating' => $rating
		);
	}

	public static function settings_default() {
		return array(
			'fsrs_st_up_star_size' => 25,
			'fsrs_st_down_star_size' => 37,
			'fsrs_st_up_star_show' => '1',
			'fsrs_st_down_thanks_text' => 'تشکر! رای شما ثبت شد.',
			'fsrs_st_down_font_size' => 20
		);
	}

	public static function star_texts() {
		return array(
			'star1' => 'بد',
			'star2' => 'متوسط',
			'star3' => 'خوب',
			'star4' => 'عالی',
			'star5' => 'بسیار عالی'
		);
	}
}