jQuery(document).ready(function ($) {
    var fsrs_st_up_star_size, fsrs_st_up_star_show, fsrs_st_down_star_size, fsrs_st_down_thanks_text;
    var star1, star2, star3, star4, star5;

    //init rating settings
    getRatingSettings();

    function getRatingSettings() {
        var data = {
            action: "fsrs_get_rating_settings",
            nonce: fsrs_object._wpnonce
        };
        jQuery.ajax({
            type: "post",
            dataType: "json",
            url: fsrs_object.ajax_url,
            data: data,
            success: function (response) {
                if (response.result == 'success') {
                    fsrs_st_up_star_size = response.fsrs_st_up_star_size;
                    fsrs_st_down_star_size = response.fsrs_st_down_star_size;
                    fsrs_st_up_star_show = response.fsrs_st_up_star_show;
                    fsrs_st_down_thanks_text = response.fsrs_st_down_thanks_text;

                    star1 = response.star1;
                    star2 = response.star2;
                    star3 = response.star3;
                    star4 = response.star4;
                    star5 = response.star5;

                    $(".my-rating").starRating({
                        totalStars: 5,
                        starShape: 'rounded',
                        strokeWidth: 0,
                        starSize: fsrs_st_down_star_size,
                        emptyColor: 'lightgray',
                        hoverColor: '#fed330',
                        useFullStars: true,
                        useGradient: false,
                        ratedColor: '#feca57',
                        disableAfterRate: true,
                        callback: function (currentRating, $el) {
                            //save post rating in db
                            var data = {
                                action: "savePostData",
                                fsrsPostId: $('#post-id').val(),
                                nonce: fsrs_object._wpnonce,
                                pRating: currentRating
                            };
                            jQuery.ajax({
                                type: "post",
                                dataType: "json",
                                url: fsrs_object.ajax_url,
                                data: data,
                                success: function (response) {
                                    if (response.result == 'success') {
                                        const ratingValue = response.ratingValue;
                                        const faRatingValue = response.faRatingDigit;
                                        const ratingCount = response.ratingCount;
                                        $('#rating-top').starRating('setRating', ratingValue);
                                        $('#fsrs-rating').starRating('setRating', ratingValue);
                                        $('.rating-hov-text').text(fsrs_st_down_thanks_text);
                                        $('.live-rating').html("میانگین امتیازات " + '<strong>' + faRatingValue + '</strong>' + " از ۵");
                                        $('.live-rating-count').html("از مجموع " + '<strong>' + ratingCount + '</strong>' + " رای");
                                    } else {
                                        $('.rating-hov-text').text("شما قبلا به این پست امتیاز داده اید!");
                                    }
                                }, error: function (error) {

                                    console.log(error);
                                }
                            });
                        }, onHover: function (currentIndex, currentRating, $el) {
                            if (currentIndex === 1)
                                $('.rating-hov-text').text(star1);
                            if (currentIndex === 2)
                                $('.rating-hov-text').text(star2);
                            if (currentIndex === 3)
                                $('.rating-hov-text').text(star3);
                            if (currentIndex === 4)
                                $('.rating-hov-text').text(star4);
                            if (currentIndex === 5)
                                $('.rating-hov-text').text(star5);
                        },
                        onLeave: function (currentIndex, currentRating, $el) {
                            $('.rating-hov-text').text("");
                        }
                    });
                    $(".my-rating-top").starRating({
                        totalStars: 5,
                        starShape: 'rounded',
                        starSize: fsrs_st_up_star_size,
                        strokeWidth: 0,
                        useFullStars: true,
                        emptyColor: 'lightgray',
                        activeColor: 'gold',
                        useGradient: false,
                        ratedColor: 'gold',
                        readOnly: true
                    });
                    if (fsrs_st_up_star_show == '0') {
                        $(".my-rating-top").remove();
                    }
                    getStarOptions();
                }
            }, error: function (error) {
                console.log(error);
                fsrs_st_up_star_size = 37;
                fsrs_st_down_star_size = 40;
                fsrs_st_down_thanks_text = 'تشکر! رای شما ثبت شد.';
            }
        });

    }

    function getStarOptions() {
        var data = {
            action: "getPostData",
            fsrsPostId: $('#post-id').val(),
            nonce: fsrs_object._wpnonce
        };
        jQuery.ajax({
            type: "post",
            dataType: "json",
            url: fsrs_object.ajax_url,
            data: data,
            success: function (response) {
                if (response.result == 'success') {
                    const ratingValue = response.ratingValue;
                    const faRating = response.faDigitValue;
                    const faRatingCount = response.faDigitCount;
                    if (fsrs_st_up_star_show == '1') {
                        $('#rating-top').starRating('setRating', ratingValue);
                    }
                    $('#fsrs-rating').starRating('setRating', ratingValue);
                    $('.live-rating')
                        .html("<span class='fsrs-ratings-info'>" + "میانگین امتیازات " + '<strong>' +
                            faRating +
                            '</strong>' + " از ۵" + '</span>');
                    $('.live-rating-count').html("<span class='fsrs-ratings-info'>" + "از مجموع " + '<strong>' +
                        faRatingCount + '</strong>' + " رای" + '</span>');
                }
            }, error: function (error) {
                console.log(error);
            }
        });
    }
});
