<?php

class FSRS_METABOX {
	public function __construct() {
		add_action( 'save_post', [ $this, 'save' ] );
		add_action( 'add_meta_boxes', [ $this, 'fsrs_add_custom_box' ] );
		add_action( 'admin_init', [ $this, 'load_assets' ] );
		add_action( 'init', [ $this, 'taxonomy_meta' ], 999 );
	}

	/**
	 * Initialize metabox
	 * @return void
	 */
	public function fsrs_add_custom_box() {
		$sc_types = $post_types = get_post_types( array( 'public' => true ) );
		foreach ( $sc_types as $sc_type ) {
			add_meta_box(
				'fsrs_rating_schema',
				'افزونه فول اسکیما سفینه',
				[ $this, 'fsrs_rating_box_html' ],
				$sc_type
			);
		}
	}

	/**
	 * Rating schema metabox callback and view
	 *
	 * @param $post
	 *
	 */
	public function fsrs_rating_box_html( $post ) {
		$vObject = get_post_meta( $post->ID, '_fsrs_schema', true );
		if ( empty( $vObject ) ) {
			$vObject = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::default_options( $post->ID, '');
		}
		$page_rating_show_option = get_post_meta( $post->ID, '_fsrs_page_star_option', true );
		if ( empty( $page_rating_show_option ) ) {
			$page_rating_show_option = array( 'showOption' => '0' );
		}
		?>
		<?php

		$post_type = get_post_type(get_the_ID());
		if ($post_type != 'product') {
			?>

            <input type="hidden" name="fsrs-schema-nonce"
                   value="<?php echo esc_attr( wp_create_nonce( 'fsrs-rating-schema' ) ); ?>">
            <div class="fsrs-rating-header" onclick="fsrsDisplayFunc()">
                <h3>
                    <span class="dashicons dashicons-star-filled"
                          style="font-size: 24px; color: #ffba00; margin-left: 4px; margin-top: -3px"></span>
                    <span>اسکیما ریتینگ (ستاره دار شدن)</span>
                </h3>
            </div>
            <div class="fsrs-rate-option-container" id="fsrs-rate-option-container">
                <div class="fsrs-rating-item">
					<?php
					if ($post_type != 'post') {
						if ( $page_rating_show_option['showOption'] == '1' ) {
							echo '
                    <div class="fsrs-rating-show-option-container">
                        <p style="margin-right: 12px">
                             <label for="fsrs-rating-show-option" class="fsrs-h4"> آیا میخواهید این صفحه ستاره دار شود؟</label>
                            <input type="checkbox" value="1" id="fsrs-rating-show-option" checked="checked"
 						    name="fsrs-rating-show-option" class="checkbox" style="margin-right: 8px;
 						    margin-top: -1px"></p></div>';
						} else {
							echo '<div class="fsrs-rating-show-option-container">
                                    <p> 
                                        <label for="fsrs-rating-show-option"> آیا میخواهید این صفحه ستاره دار شود؟</label>
                                        <input type="checkbox" value="1" id="fsrs-rating-show-option"
 						                name="fsrs-rating-show-option" class="checkbox">
 						            </p>
 						            </div>';
						}
					} else if (  $post_type == 'post'  ) {
						echo '
                        <div style="display: none;">
					    <input type="checkbox" value="1" id="fsrs-rating-show-option" checked="checked"
					    name="fsrs-rating-show-option" >
					    </div>';
					}
					echo '</div>';?>


                <div class="fsrs-schema-item">
                    <fieldset data-role="controlgroup" name="fsrs-schema" id="fsrs-schema"
                              class="postbox fsrs-schema">
                        <legend style="margin-bottom: 10px; padding-bottom: 8px" class="fsrs-h4">با چه روشی میخواهید صفحه شما ستاره دار شود؟</legend>
                        <label for="radio-choice-1">ویدیو دارم </label>
						<?php
						if ( $vObject['@type'] == 'VideoObject' ) {
							echo '<input type="radio" name="fsrs-schema-radio" checked="checked"
 									 id="radio-choice-1" value="1" data-mini="true"/>';
						} else {
							echo '<input type="radio" name="fsrs-schema-radio" id="radio-choice-1" value="1" data-mini="true"/>';
						}
						?>

                        <label for="radio-choice-2">فایل صوتی دارم </label>
						<?php
						if ( $vObject['@type'] == 'AudioObject' ) {
							echo '<input type="radio" name="fsrs-schema-radio" id="radio-choice-2"
 									 value="2" checked="checked" data-mini="true"/>';
						} else {
							echo '<input type="radio" name="fsrs-schema-radio" id="radio-choice-2" value="2" data-mini="true"/>';
						}
						?>

                        <label for="radio-choice-3">روش پیشفرض </label>
						<?php
						if ( $vObject['@type'] == 'MediaObject' ) {
							echo '<input type="radio" name="fsrs-schema-radio"
 							  id="radio-choice-3" checked="checked" value="3" data-mini="true"/>';
						} else {
							echo '<input type="radio" name="fsrs-schema-radio"
 							  id="radio-choice-3" value="3" data-mini="true"/>';
						}
						?>
                    </fieldset>
                    <div class="fsrs-video-object">
                        <p>
                            <label for="fsrs-vo-title" class="fsrs-meta-label"><?php esc_html_e( 'عنوان', 'fsrs-schema' ); ?></label>
                            <input type="text" id="fsrs-vo-title" name="fsrs-vo-title" class="widefat fsrs-schema-input"
                                   value="<?php echo esc_html( ! empty( $vObject['name'] ) ?
								       $vObject['name'] : '' ); ?>">
                        </p>
                        <p>
                            <label for="fsrs-vo-desc" class="fsrs-meta-label"><?php esc_html_e( 'توضیحات', 'fsrs-schema' ); ?></label>
                            <textarea id="fsrs-vo-desc" name="fsrs-vo-desc" rows="4"
                                      class="widefat fsrs-schema-input" style="height: auto!important;"><?php
								echo esc_attr( ! empty( $vObject['description'] ) ?
									$vObject['description'] : '' ); ?></textarea>
                        </p>
                        <p>
                            <label for="fsrs-vo-duration" class="fsrs-meta-label"><?php esc_html_e( 'مدت زمان (SثانیهMدقیقهPT)', 'fsrs-schema' ); ?></label>
                            <input type="text" id="fsrs-vo-duration" name="fsrs-vo-duration"
                                   class="widefat fsrs-schema-input" placeholder="" value="<?php
							echo esc_attr( ! empty( $vObject['duration'] ) ?
								$vObject['duration'] : '' ); ?>">
                        </p>
                        <p>
                            <label for="fsrs-vo-video-url" class="fsrs-meta-label"><?php esc_html_e( 'url مدیای صفحه', 'fsrs-schema' ); ?></label>
                            <input type="text" id="fsrs-vo-video-url" name="fsrs-vo-video-url"
                                   class="widefat fsrs-schema-input" value="<?php
							echo esc_attr( ! empty( $vObject['contentUrl'] ) ?
								$vObject['contentUrl'] : '' ); ?>">
                        </p>
                    </div>
                </div>
            </div>

            <div class="fsrs-rating-header fsrs-faq-div" onclick="fsrsFaqDisplayFunc()">
                <h3>
                    <span class="dashicons dashicons-edit-large"
                          style="font-size: 24px; color: #ffba00; margin-left: 4px; margin-top: -3px"></span>
                    <span class="h3">اسکیما سوال و جواب</span>
                </h3>
            </div>
            <div class="fsrs-faq-div-cont" id="fsrs-faq-div-cont">
				<?php $this->fsrs_custom_box_html( $post ); ?>
            </div>
			<?php
		}
		?>
        <div class="fsrs-rating-header fsrs-script-div" onclick="scriptDisplayFunc()">
            <h3>
                <span class="dashicons dashicons-plus-alt2"
                      style="font-size: 24px; color: #ffba00; margin-left: 4px; margin-top: -3px"></span>
                <span class="h3">تزریق اسپکریپت</span>
            </h3>
        </div>
        <div class="fsrs-script-div-count" id="fsrs-script-div-count">
			<?php
			$this->fsrsInjectScriptBoxHtml( $post );
			?>
        </div>
		<?php
	}

	/**
	 * Add script metabox callback and view
	 *
	 * @param $post
	 *
	 * @return void
	 */
	public function fsrsInjectScriptBoxHtml( $post ) {
		$post_id      = $post->ID;
		$post_scripts = get_post_meta( $post_id, '_fsrs_script', true );
		?>
        <div class="fsrs-script-container">
            <input type="hidden" name="fsrs-script-nonce"
                   value="<?php echo esc_attr( wp_create_nonce( 'fsrs-script' ) ); ?>">
            <p>
                <label for="fsrs-script-header" class="fsrs-meta-label"><?php esc_html_e( 'تزریق کد به هدر (header)',
						'fsrs-script' ); ?></label>
                <textarea id="fsrs-script-header" rows="7" name="fsrs-script-header" class="widefat fsrs-schema-input"
                style="height: auto!important; direction: ltr" placeholder="کد را اینجا وارد کنید"><?php
					echo esc_html( ! empty( $post_scripts['header'] ) ? $post_scripts['header'] : '' ); ?></textarea>
            </p>
            <p>
                <label for="fsrs-script-footer" class="fsrs-meta-label"><?php esc_html_e( 'تزریق کد به فوتر (footer)',
						'fsrs-script' ); ?></label>
                <textarea id="fsrs-script-footer" rows="7" name="fsrs-script-footer" class="widefat fsrs-schema-input"
                style="height: auto!important; direction: ltr" placeholder="کد را اینجا وارد کنید"><?php
					echo esc_html( ! empty( $post_scripts['footer'] ) ? $post_scripts['footer'] : '' ); ?></textarea>
            </p>
        </div>
		<?php
	}

	/**
	 * FAQ metabox callback and view
	 *
	 * @param $post
	 *
	 * @return void
	 */
	public function fsrs_custom_box_html( $post ) {
		$faqs = get_post_meta( $post->ID, '_fsrs_faq_schema', true );
		if ( empty( $faqs ) ) {
			$faqs = [
				[
					'q' => '',
					'a' => '',
				],
			];
		}

		?>
        <input type="hidden" name="fsrs-faq-schema-nonce"
               value="<?php echo esc_attr( wp_create_nonce( 'fsrs-faq-schema' ) ); ?>">
        <!-- FAQ View     -->
        <div class="fsrs-faq-schema-container">
            <div class="fsrs-faq-schema-items">
				<?php foreach ( $faqs as $index => $faq ) : ?>
                    <div class="fsrs-faq-schema-item">
                        <div class="fsrs-faq-schema-header">
							<span style="font-weight: bold">
								<?php
								/* translators: index */
								echo esc_html( ! empty( $faq['q'] ) ? $faq['q'] : sprintf( __( 'سوال #%s',
									'fsrs-faq-schema' ), $index + 1 ) );
								?>
							</span>
                            <button class="fsrs-faq-schema-delete" type="button"
                                    data-confirm="<?php esc_html_e( 'برای پاک کردن این آیتم اطمینان دارید؟',
								        'fsrs-faq-schema' ); ?>">
                                <span class="dashicons dashicons-trash"></span></button>
                        </div>
                        <div class="fsrs-faq-schema">
                            <p>
                                <label for="fsrs-faq-schema-q-<?php echo esc_attr( $index ); ?>" class="fsrs-meta-label">
									<?php esc_html_e( 'سوال', 'fsrs-faq-schema' ); ?></label>
                                <input type="text" id="fsrs-faq-schema-q-<?php echo esc_attr( $index ); ?>"
                                       name="fsrs-faq-schema[<?php echo esc_attr( $index ); ?>][q]"
                                       class="widefat fsrs-schema-input"
                                       value="<?php echo esc_attr( ! empty( $faq['q'] ) ? $faq['q'] : '' ); ?>">
                            </p>
                            <p>
                                <label for="fsrs-faq-schema-a-<?php echo esc_attr( $index ); ?>" class="fsrs-meta-label">
									<?php esc_html_e( 'جواب', 'fsrs-faq-schema' ); ?></label>
                                <textarea name="fsrs-faq-schema[<?php echo esc_attr( $index ); ?>][a]"
                                          id="fsrs-faq-schema-a-<?php echo esc_attr( $index ); ?>" rows="3"
                                          class="widefat fsrs-schema-input" style="height: auto!important;"><?php
									echo esc_html(! empty( $faq['a'] ) ? $faq['a'] : '' ); ?></textarea>
                            </p>
                        </div>
                    </div>
				<?php endforeach; ?>
            </div>
			<?php /* translators: index */ ?>
            <button type="button" class="button button-primary fsrs-faq-schema-add"
                    data-index="<?php echo count( $faqs ); ?>"
                    data-title="<?php esc_attr_e( 'سوال #%s', 'fsrs-faq-schema' ); ?>">
				<?php echo esc_html_e( 'اضافه کردن یک سوال جدید', 'fsrs-faq-schema' ); ?>
            </button>
        </div>
        <script type="text/html" id="tmpl-faq-schema-form">
            <div class="fsrs-faq-schema-item">
                <div class="fsrs-faq-schema-header">
                    <span style="font-weight: bold;">{TITLE}</span>
                    <button class="fsrs-faq-schema-delete" type="button"
                            data-confirm="<?php esc_attr_e( 'مطمئن هستید که میخواهید این آیتم را پاک کنید؟',
						        'fsrs-faq-schema' ); ?>">
                        <span class="dashicons dashicons-trash"></span></button>
                </div>
                <div class="fsrs-faq-schema">
                    <p>
                        <label for="fsrs-faq-schema-q-{INDEX}" class="fsrs-meta-label"><?php esc_html_e( 'سوال', 'fsrs-faq-schema' ); ?></label>
                        <input type="text" id="fsrs-faq-schema-q-{INDEX}" name="fsrs-faq-schema[{INDEX}][q]"
                               class="widefat fsrs-schema-input">
                    </p>
                    <p>
                        <label for="fsrs-faq-schema-a-{INDEX}" class="fsrs-meta-label"><?php esc_html_e( 'جواب', 'fsrs-faq-schema' ); ?></label>
                        <textarea id="fsrs-faq-schema-a-{INDEX}" name="fsrs-faq-schema[{INDEX}][a]" rows="3"
                                  class="widefat fsrs-schema-input" style="height: auto!important;"></textarea>
                    </p>
                </div>
            </div>
        </script>
		<?php
	}

	/**
	 * Save meta values
	 *
	 * @param int $post_id Post ID.
	 *
	 * @access public
	 *
	 * @return void
	 */
	public function save( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
			return;
		}


		$this->saveFAQOptions( $post_id );
		$this->savefsrsSchema( $post_id );
		$this->saveFsrsInjectScript( $post_id );
	}

	/**
	 * save FAQ Options
	 *
	 * @param $post_id
	 */
	public function saveFAQOptions( $post_id ) {
		if ( ! isset( $_POST['fsrs-faq-schema-nonce'] ) || !
			wp_verify_nonce( sanitize_key( $_POST['fsrs-faq-schema-nonce'] ), 'fsrs-faq-schema' ) ) {
			return;
		}
		update_post_meta( $post_id, '_fsrs_faq_schema',
			! isset( $_POST['fsrs-faq-schema'] ) ? [] : $this->sanitize( $_POST['fsrs-faq-schema'] ) ); // phpcs:ignore
	}

	/**
	 * Save rating Options
	 *
	 * @param $post_id
	 */
	public function savefsrsSchema( $post_id ) {
		if ( ! isset( $_POST['fsrs-schema-nonce'] ) || !
			wp_verify_nonce( sanitize_key( $_POST['fsrs-schema-nonce'] ), 'fsrs-rating-schema' ) ) {
			return;
		}

		$radioVal          = ! isset( $_POST["fsrs-schema-radio"] ) ? '3' : $_POST["fsrs-schema-radio"];
		$page_show_options = ! isset( $_POST['fsrs-rating-show-option'] ) ? '' : $_POST['fsrs-rating-show-option'];
		$desc              = ! isset( $_POST['fsrs-vo-desc'] ) ? '' : $_POST['fsrs-vo-desc'];
		$contentUrl        = ! isset( $_POST['fsrs-vo-video-url'] ) ? '' : $_POST['fsrs-vo-video-url'];
		$title             = ! isset( $_POST['fsrs-vo-title'] ) ? '' : $_POST['fsrs-vo-title'];
		$duration          = ! isset( $_POST['fsrs-vo-duration'] ) ? '' : $_POST['fsrs-vo-duration'];

		$n_content_url = strval($contentUrl);
		if ( get_post_type() == 'page' ) {
			if ( $page_show_options == '1' ) {
				if ( empty( $title ) ) {
					$title = get_the_title( $post_id );
				}
				$new_meta_value = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::default_options( $post_id, $title );
				if ( $radioVal == '1' ) {
					$new_meta_value = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::video_object_options( $post_id, $title, $desc, $duration,
						$n_content_url );
				}
				if ( $radioVal == '2' ) {
					$new_meta_value = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::audio_object_options( $duration, $title, $desc,
						$n_content_url );
				}
				if ( $radioVal == '3' ) {
					$new_meta_value = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::default_options( $post_id, $title );
				}
				update_post_meta( $post_id, '_fsrs_schema', $new_meta_value );
				update_post_meta( $post_id, '_fsrs_page_star_option', array( 'showOption' => '1' ) );
			} else {
				update_post_meta( $post_id, '_fsrs_page_star_option', array( 'showOption' => '0' ) );
			}
		} else {
			if ( empty( $title ) ) {
				$title = get_the_title( $post_id );
			}
			$new_meta_value = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::default_options( $post_id, $title );
			if ( $radioVal == '1' ) {
				$new_meta_value = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::video_object_options( $post_id, $title, $desc, $duration,
					$n_content_url);
			}
			if ( $radioVal == '2' ) {
				$new_meta_value = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::audio_object_options( $duration, $title, $desc,
					$n_content_url);
			}
			if ( $radioVal == '3' ) {
				$new_meta_value = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::default_options( $post_id, $title );
			}
			update_post_meta( $post_id, '_fsrs_schema', $new_meta_value );
		}
	}

	/**
	 *Save inject script
	 *
	 * @param $post_id
	 */
	public function saveFsrsInjectScript( $post_id ) {
		if ( ! isset( $_POST['fsrs-script-nonce'] ) || !
			wp_verify_nonce( sanitize_key( $_POST['fsrs-script-nonce'] ), 'fsrs-script' ) ) {
			return;
		}

		$header      = ! isset( $_POST['fsrs-script-header'] ) ? '' : $_POST['fsrs-script-header'];
		$footer      = ! isset( $_POST['fsrs-script-footer'] ) ? '' : $_POST['fsrs-script-footer'];
		$script_data = array(
			'header' => $header,
			'footer' => $footer
		);
		update_post_meta( $post_id, '_fsrs_script', $script_data );
	}

	/**
	 * Sanitize full array
	 *
	 * @param array $faqs Array.
	 *
	 * @access public
	 *
	 * @return  array
	 */
	public function sanitize( $faqs ) {
		$new_faqs = [];

		if ( ! empty( $faqs ) && is_array( $faqs ) ) {
			foreach ( $faqs as $faq ) {
				$new_faq = [];

				if ( ! empty( $faq['q'] ) ) {
					$new_faq['q'] = sanitize_text_field( $faq['q'] );
				}
				if ( ! empty( $faq['a'] ) ) {
					$new_faq['a'] = $faq['a'];
					strval($new_faq);
				}
				if ( ! empty( $new_faq ) ) {
					$new_faqs[] = $new_faq;
				}
			}
		}

		return $new_faqs;
	}

	public function taxonomy_meta() {
		$taxonomies = get_taxonomies( [ 'publicly_queryable' => true ] );
		$taxonomies = array_keys( $taxonomies );

		foreach ( $taxonomies as $taxonomy ) {
			add_filter( $taxonomy . '_add_form_fields', array( $this, 'tax_meta' ) );
			add_filter( $taxonomy . '_edit_form_fields', array( $this, 'tax_meta_edit' ) );

			add_action( 'edit_' . $taxonomy, array( $this, 'save_tax_meta' ) );
			add_action( 'create_' . $taxonomy, array( $this, 'save_tax_meta' ) );
		}

	}

	public function tax_meta() {
		?>
        <div class="form-field is-tax">
			<?php $this->tax_meta_label(); ?>
			<?php $this->tax_meta_view( false ); ?>
        </div>
		<?php
	}

	public function tax_meta_edit( $term ) {
		?>
        <tr class="form-field store-logo-wrap">
            <th scope="row">
				<?php $this->tax_meta_label(); ?>
            </th>
            <td>
                <div class="is-tax">
					<?php $this->tax_meta_view( $term->term_id ); ?>
                </div>
            </td>
        </tr>
		<?php
	}

	public function tax_meta_label() {
		?>
        <label class="is-tax-label"><?php printf( __( 'اسکیما faq برای پست ها و برگه ها %s', 'fsrs-faq-schema' ),
				' <span class="dashicons dashicons-info" 
				title="' . __( 'برای ذخیره کردن دکمه بروزرسانی پست یا برگه را بزنید. اطلاعات پس کلیک روی دکمه ذخیره میشوند.',
					'fsrs-faq-schema' ) . '"></span>' ) ?></label>
		<?php
	}

	public function tax_meta_view( $term_id ) {
		$faqs = $term_id ? get_term_meta( $term_id, '_fsrs_faq_schema', true ) : '';

		if ( empty( $faqs ) ) {
			$faqs = [
				[
					'q' => '',
					'a' => '',
				],
			];
		}
		?>
        <div class="fsrs-faq-schema-container">
            <input type="hidden" name="fsrs-faq-schema-nonce"
                   value="<?php echo esc_attr( wp_create_nonce( 'fsrs-faq-schema' ) ); ?>">
            <div class="fsrs-faq-schema-items">
				<?php foreach ( $faqs as $index => $faq ) : ?>
                    <div class="fsrs-faq-schema-item">
                        <div class="fsrs-faq-schema-header">
							<span>
								<?php
								/* translators: index */
								echo esc_html( ! empty( $faq['q'] ) ? $faq['q'] : sprintf( __( 'سوال #%s',
									'fsrs-faq-schema' ), $index + 1 ) );
								?>
							</span>
                            <button class="fsrs-faq-schema-delete" type="button"
                                    data-confirm="<?php esc_html_e( 'برای پاک کردن این آیتم اطمینان دارید؟',
								        'fsrs-faq-schema' ); ?>">
                                <span class="dashicons dashicons-trash"></span></button>
                        </div>
                        <div class="fsrs-faq-schema">
                            <p>
                                <label for="fsrs-faq-schema-q-<?php echo esc_attr( $index ); ?>" class="fsrs-meta-label">
									<?php esc_html_e( 'سوال', 'fsrs-faq-schema' ); ?></label>
                                <input type="text" id="fsrs-faq-schema-q-<?php echo esc_attr( $index ); ?>"
                                       name="fsrs-faq-schema[<?php echo esc_attr( $index ); ?>][q]"
                                       class="widefat fsrs-schema-input" style="height: auto!important;"
                                       value="<?php echo esc_attr( ! empty( $faq['q'] ) ? $faq['q'] : '' ); ?>">
                            </p>
                            <p>
                                <label for="fsrs-faq-schema-a-<?php echo esc_attr( $index ); ?>" class="fsrs-meta-label">
									<?php esc_html_e( 'جواب', 'fsrs-faq-schema' ); ?></label>
                                <textarea name="fsrs-faq-schema[<?php echo esc_attr( $index ); ?>][a]"
                                          id="fsrs-faq-schema-a-<?php echo esc_attr( $index ); ?>" rows="3"
                                          style="height: auto!important;"
                                          class="widefat fsrs-schema-input"><?php echo esc_html( ! empty( $faq['a'] ) ? $faq['a'] : '' ); ?></textarea>
                            </p>
                        </div>
                    </div>
				<?php endforeach; ?>
            </div>
			<?php /* translators: index */ ?>
            <button type="button" class="button button-primary fsrs-faq-schema-add"
                    data-index="<?php echo count( $faqs ); ?>"
                    data-title="<?php esc_attr_e( 'سوال #%s', 'fsrs-faq-schema' ); ?>">
				<?php echo esc_html_e( 'اضافه کردن یک سوال جدید', 'fsrs-faq-schema' ); ?>
            </button>
        </div>
        <script type="text/html" id="tmpl-faq-schema-form">
            <div class="fsrs-faq-schema-item">
                <div class="fsrs-faq-schema-header">
                    <span>{TITLE}</span>
                    <button class="fsrs-faq-schema-delete" type="button"
                            data-confirm="<?php esc_attr_e( 'مطمئن هستید که میخواهید این آیتم را پاک کنید؟',
						        'fsrs-faq-schema' ); ?>">
                        <span class="dashicons dashicons-trash"></span></button>
                </div>
                <div class="fsrs-faq-schema">
                    <p>
                        <label for="fsrs-faq-schema-q-{INDEX}" class="fsrs-meta-label"><?php esc_html_e( 'سوال', 'fsrs-faq-schema' ); ?></label>
                        <input type="text" id="fsrs-faq-schema-q-{INDEX}" name="fsrs-faq-schema[{INDEX}][q]"
                               class="widefat fsrs-schema-input">
                    </p>
                    <p>
                        <label for="fsrs-faq-schema-a-{INDEX}" class="fsrs-meta-label"><?php esc_html_e( 'جواب', 'fsrs-faq-schema' ); ?></label>
                        <textarea id="fsrs-faq-schema-a-{INDEX}" name="fsrs-faq-schema[{INDEX}][a]" rows="3"
                        style="height: auto!important;"
                                  class="widefat fsrs-schema-input"></textarea>
                    </p>
                </div>
            </div>
        </script>
		<?php
	}

	public function save_tax_meta( $term_id ) {
		if ( ! isset( $_POST['fsrs-faq-schema-nonce'] ) || !
			wp_verify_nonce( sanitize_key( $_POST['fsrs-faq-schema-nonce'] ), 'fsrs-faq-schema' ) ) {
			return;
		}

		update_term_meta( $term_id, '_fsrs_faq_schema',
			! isset( $_POST['fsrs-faq-schema'] ) ? [] : $this->sanitize( $_POST['fsrs-faq-schema'] ) );
	}

	/**
	 * load admin assets
	 */
	public function load_assets() {
		wp_enqueue_style( 'fsrs-faq-schema-style', FSRS_ADMIN_URL . 'css/fsrs-admin-style.css',
			false );

		wp_enqueue_script( 'sweetalert2', FSRS_ADMIN_URL . 'js/sweetalert2.all.min.js',
			[ 'jquery' ], '1.0.0', true );
		wp_enqueue_script( 'papaparse', FSRS_ADMIN_URL . 'js/papaparse.min.js',
			[ 'jquery' ], '1.0.0', true );
		wp_enqueue_script( 'fsrs-faq-schema-scripts', FSRS_ADMIN_URL . 'js/fsrs-admin-main.js', [
			'jquery',
			'papaparse',
			'sweetalert2'
		], '1.0.0', true );
		$data = 'var wfs_ajax="' . admin_url( 'admin-ajax.php' ) . '";';
		wp_add_inline_script( 'fsrs-faq-schema-scripts', $data, 'before' );

	}
}
