<?php

class FSRS_SETTINGS_MENU {
	public function __construct() {
		$this->init_view();
	}

	public function init_view() {
		?>
        <div class="fsrs-wrapper">
			<?php
			$this->customize_stars();
			$this->customize_texts();
			$this->reset_plugin(); ?>
        </div>
		<?php
	}

	public function customize_stars() {
		$def_settings = get_option( 'fsrs_def_settings', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::settings_default() );
		?>
        <div class="fsrs-alert-container">
            <h3 class="fsrs-setting-box" id="fsrs-setting-rating" onclick="fsrsAdminCS()">
                <span class="dashicons dashicons-admin-customizer"></span>
                تغییر ظاهر ستاره‌ها
            </h3>
            <div id="fsrs-admin-form1">
                <div class="fsrs-alert-container-item fsrs-alert-container"
                     style="margin-bottom: 12px; padding-bottom: 12px; border-right: 3px solid #ffbd5b;">
                    <table class="form-table">
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-st-up-star-size">اندازه ستاره بالا</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="fsrs_st_up_star_size" id="fsrs-st-up-star-size"
                                       value="<?php echo $def_settings['fsrs_st_up_star_size'] ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-st-down-star-size">اندازه ستاره پایین</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="fsrs-st-down-star-size" id="fsrs-st-down-star-size"
                                       value="<?php echo $def_settings['fsrs_st_down_star_size'] ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-st-up-star-show">ستاره بالا نمایش داده شود؟</label>
                            </th>
                            <td class="forminp forminp-text">
								<?php $select_value = $def_settings['fsrs_st_up_star_show'];
								?>
                                <select id="fsrs-st-up-star-show">
                                    <option value="1" <?php if ( $select_value == '1' ) {
									?>selected <?php } ?>>بله
                                    </option>
                                    <option value="0" <?php if ( $select_value == '0' ) {
									?>selected <?php } ?>>خیر
                                    </option>
                                </select>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-st-down-thanks-text">متن تشکر</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="fsrs-st-down-thanks-text" id="fsrs-st-down-thanks-text"
                                       value="<?php echo $def_settings['fsrs_st_down_thanks_text'] ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-st-down-font-size">اندازه فونت متن‌های زیر ستاره</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="fsrs-st-down-font-size" id="fsrs-st-down-font-size"
                                       value="<?php echo $def_settings['fsrs_st_down_font_size'] ?>">
                            </td>
                        </tr>
                    </table>
                    <input type="button" class="fsrs-btn-primary" value="ثبت تغییرات" id="fsrs-settings-save"
                           style="background-image: linear-gradient(66deg, #e29b31 0%, #efb054 100%);">
                    <div class="loader loader1" style="display: none; margin-bottom: 16px!important; margin-top: 8px;
                               margin-right: 12px!important;"></div>
                    <span class="save_setting_response"></span>
                </div>
            </div>
        </div>
		<?php
	}

	public function customize_texts() {
		$star_settings = get_option( 'fsrs_star_texts', FULL_SCHEMA_RICH_SNIPPET_SETTINGS::star_texts() ); ?>
        <div class="fsrs-alert-container">
            <h3 class="fsrs-setting-box" id="fsrs-setting-rating" onclick="fsrsAdminSH()">
                <span class="dashicons dashicons-admin-customizer"></span>
                سفارشی سازی متن امتیازها
            </h3>
            <div id="fsrs-admin-form">
                <div class="fsrs-alert-container-item fsrs-alert-container" style="margin-bottom: 16px;">
                    <table class="form-table">
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-first-rating">متن ستاره اول</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="star1" id="fsrs-first-rating"
                                       value="<?php echo $star_settings['star1'] ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-second-rating">متن ستاره دوم</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="star2" id="fsrs-second-rating"
                                       value="<?php echo $star_settings['star2'] ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-third-rating">متن ستاره سوم</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="star3" id="fsrs-third-rating"
                                       value="<?php echo $star_settings['star3'] ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-four-rating">متن ستاره چهارم</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="star4" id="fsrs-four-rating"
                                       value="<?php echo $star_settings['star4'] ?>">
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row" class="titledesc">
                                <label for="fsrs-five-rating">متن ستاره پنجم</label>
                            </th>
                            <td class="forminp forminp-text">
                                <input type="text" name="star5" id="fsrs-five-rating"
                                       value="<?php echo $star_settings['star5'] ?>">
                            </td>
                        </tr>
                    </table>
                    <input type="button" class="fsrs-btn-primary" value="ثبت تغییرات"
                           style="background-image: linear-gradient(66deg, #d65020 0%, #ff7b4c 100%);"
                           id="fsrs_save_star_texts">
                    <div class="loader loader2"
                         style="display: none;
                         margin-bottom: 16px!important; margin-top: 8px; margin-right: 0!important;"></div>
                    <span class="save_star_text_response"></span>
                </div>
            </div>
        </div>
		<?php
	}

	public function reset_plugin() {
		?>
        <div class="fsrs-alert-container">
            <h3 class="fsrs-setting-box" id="fsrs-setting-rating" onclick="fsrsAdminResetSH()">
                <span class="dashicons dashicons-admin-tools"></span>
                راه‌اندازی مجدد فول اسکیما
            </h3>
            <div id="reset-settings-container">
                <p style="font-size: 17px; color: #ff2b00; font-weight: bold">
                    *اخطار! با راه‌اندازی مجدد، تمام تنظیمات افزونه و تغییرات شما به حالت اولیه باز می‌گردند.*
                </p>
                <div style="display: inline-block; margin-bottom: 16px">
                    <button class="button-primary btn-reset-plugin" style="margin-bottom: 16px" type="button">
                        راه‌اندازی مجدد
                    </button>
                    <span class="fsrs-reset-response" style=" margin-bottom: 16px!important;"></span>
                    <div class="loader loader3"
                         style="margin-right: 24px!important; margin-bottom: 16px!important;"></div>
                </div>
            </div>
        </div>
        <script>
            jQuery(document).ready(function ($) {
                const admin_url = "<?php echo admin_url( 'admin-ajax.php' )?>";
                const nonce = "<?php echo wp_create_nonce( 'fsrs-reset-nonce' )?>";
                $('.loader3').hide();
                $('.btn-reset-plugin').on('click', function (e) {
                    e.preventDefault();
                    $('.loader3').show();
                    if (window.confirm("آیا مطمئن هستید؟")) {
                        $('.btn-reset-plugin').hide();
                        var data = {
                            action: "fsrs_reset",
                            nonce: nonce
                        };
                        jQuery.ajax({
                                type: "POST",
                                dataType: "json",
                                url: admin_url,
                                data: data,
                                success: function (response) {
                                    console.log(response);
                                    if (response.code == '1') {
                                        $('.loader3').hide();
                                        $('.fsrs-reset-response').addClass('fsrs-success');
                                        $('.fsrs-reset-response').show();
                                        $('.fsrs-reset-response').text("تنظیمات افزونه به حالت اولیه بازگشت.");

                                        setTimeout(hideResponse, 2000);
                                        function hideResponse() {
                                            $('.fsrs-reset-response').hide();
                                            location.reload();
                                        }
                                    }
                                },
                                error: function (error) {
                                    $('.loader3').hide();
                                    console.log(error);
                                }
                            }
                        )
                    } else {
                        $('.loader3').hide();
                    }
                });

            });
        </script>
		<?php
	}
}