<?php

class FSRS_PROMOTION_VIEW {
	public static $url = 'https://safine.net/fsrs-promotion.php';

	public function __construct() {
		$this->adsView();
	}

	public function adsView() {
		$this->serverReq();
	}

	public function serverReq() {
		$response = wp_remote_post( self::$url, array(
				'method'      => 'POST',
				'timeout'     => 45,
				'redirection' => 5,
				'httpversion' => '1.0',
				'blocking'    => true,
				'headers'     => array(),
				'body'        => array(
					'param1' => 'value1'
				),
				'cookies'     => array()
			)
		);

		if ( is_wp_error( $response ) ) {
			$error_message = $response->get_error_message();
			echo ": متسفانه مشکلی رخ داده است! $error_message";
		} else {
			$image_url = ! isset( $response['imageUrl'] ) ? '' : $response['imageUrl'];
			$ads_url   = ! isset( $response['adsUrl'] ) ? '' : $response['adsUrl'];
			$title     = ! isset( $response['title'] ) ? '' : $response['title'];
			?>
            <div class="wrap">
                <a href="<?php echo $ads_url ?>">
                    <img src="<?php echo $image_url ?> " alt="<?php echo $title ?>" style="width: 100%; height: auto;
				margin-bottom: 8px">
                    <h3><?php echo $title ?></h3>
                </a>
            </div>
			<?php
		}
	}
}
