<?php

class FSRS_ADMIN_SETTING {
	private $response, $notif_size = 0;

	public function __construct() {
		add_action( 'admin_menu', [ $this, 'fsrsMenuPage' ] );
		add_action( 'admin_enqueue_scripts', [ $this, 'load_assets' ] );
	}

	public function load_assets() {
		wp_enqueue_style( 'fsrs-faq-schema-style', FSRS_ADMIN_URL . 'css/fsrs-admin-style.css',
			false );
		wp_register_script( 'fsrs_admin_setting', FSRS_ADMIN_URL . 'js/fsrs-admin-settings.js',
			array( 'jquery' ), '', true );
		$nonce = wp_create_nonce( "fsrs_admin_nonce" );
		wp_localize_script( 'fsrs_admin_setting', 'fsrs_object', array(
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'nonce'    => $nonce
		) );
		wp_enqueue_script( 'fsrs_admin_setting' );
	}

	public function fsrsMenuPage() {
		$this->response       = wp_remote_post( 'https://safine.net/api/fsrs/apigetvalue.php', array(
			'method'      => 'POST',
			'timeout'     => 45,
			'redirection' => 5,
			'httpversion' => '1.0',
			'blocking'    => true,
		) );
		$var1                 = $this->response['body'];
		$obj                  = json_decode( $var1 );
		$notif_option_content = get_option( 'fsrs_notif_option' );
		if ( $notif_option_content['notif_content'] != $obj->{'info'} ) {
			$this->notif_size = $obj->{'notif_size'};
		}
		$menu_title = '<div class="fsrs-main-menu">فول اسکیما
                       </div>';
		if ( $this->notif_size > 0) {
			$menu_title = '<div class="fsrs-main-menu">فول اسکیما
                        <span class="fsrs-main-notif" style="background: #f16334;
                           font-size: 12px; display: inline-block; width: 20px; height: 20px;
                           text-align: center; font-family: tahoma; line-height: 1.5;
                           border-radius: 100px; color: white">' . $this->notif_size . '
                        </span>
                       </div>';
		}
		add_menu_page(
			'تنظیمات فول اسکیما',
			$menu_title,
			'administrator',
			'full-schema-rich-snippet',
			'',
			'data:image/png;base64,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',
			'73'
		);
		add_submenu_page( 'full-schema-rich-snippet', 'داشبورد', 'داشبورد',
			'administrator', 'full-schema-rich-snippet', [ $this, 'fsrs_callback' ] );
		add_submenu_page( 'full-schema-rich-snippet', 'تنظیمات', 'تنظیمات',
			'administrator', 'fsrs-settings', [ $this, 'fsrs_settings_callback' ] );
		add_submenu_page( 'full-schema-rich-snippet', 'فعالسازی', 'فعالسازی',
			'administrator', 'fsrs-activation', [ $this, 'fsrs_activate_callback' ] );

	}

	public function fsrs_callback() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		$var1 = $this->response['body'];
		$obj  = json_decode( $var1 ); ?>
        <div class="fsrs-wrapper">
            <div class="fsrs-alert-container fsrs-guide-alert">
                <h3 class="fsrs-setting-box" id="fsrs-setting-rating" onclick="fsrsAdminGuideSH()">
                    <span class="dashicons dashicons-book"></span>
                    آموزش استفاده فول اسکیما
                </h3>
                <div class="fsrs-setting-rating-guide" id="fsrs-setting-rating-guide">
					<?php
					if ( is_wp_error( $this->response ) ) {
						$error_message = $this->response->get_error_message();
						echo "Something went wrong: $error_message";
					} else {
						$var1 = $this->response['body'];
						$obj  = json_decode( $var1 );
						print $obj->{'alert'};
					}
					?>
                </div>
            </div>
            <div class="fsrs-alert-container fsrs-info-alert">
                <h3 class="fsrs-setting-box" id="fsrs-setting-rating">
                    <span class="dashicons dashicons-info"></span>
                    اطلاعیه‌ها
					<?php if ( $this->notif_size > 0 ) { ?>
                        <span class="fsrs-main-notif" style="background: #f16334;
                            font-size: 14px;
                            display: inline-block;
                            width: 20px;
                            height: auto;
                            text-align: center;
                            font-family: tahoma;
                            padding: 3px;
                            border-radius: 100px;
                            color: white;
                            font-weight: 600;"><?php echo $this->notif_size ?>
                        </span><?php } ?>
                    <span class="dashicons dashicons-visibility" id="fsrs-notif-is-seen" style="float: left;
                    cursor: pointer"></span>
                    <input type="hidden" value="<?php echo $this->notif_size ?>" id="notif-size">
                    <input type="hidden" value="<?php echo $obj->{'info'} ?>" id="notif-body">
                </h3>
                <div class="fsrs-setting-rating-guide" id="fsrs-setting-rating-guide">
					<?php
					if ( is_wp_error( $this->response ) ) {
						$error_message = $this->response->get_error_message();
						echo "Something went wrong: $error_message";
					} else {
						$var1 = $this->response['body'];
						$obj  = json_decode( $var1 );
						print $obj->{'info'};
					}
					?>
                </div>
            </div>
        </div>
		<?php
	}

	public function fsrs_settings_callback() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		require FSRS_ADMIN_DIR . 'template/class-fsrs-settings-menu.php';
		new FSRS_SETTINGS_MENU();
	}

	public function fsrs_activate_callback() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		} ?>
        <div class="fsrs-wrapper">
            <div class="fsrs-alert-container fsrs-activate-license"
                 style="padding-bottom: 24px!important; text-align: center">
				<?php require FSRS_ADMIN_DIR . 'template/class-fsrs-activation.php';
				new FSRS_ACTIVATION(); ?>
            </div>
        </div>
		<?php
	}

}
