<?php

class FSRS_ACTIVATION
{
    public function __construct()
    {
        $this->setup_activation_view();
        $this->enqueue_scripts();
    }

    public function setup_activation_view()
    {
        $is_licensed = get_option('fsrs-pr-license');
        $valid = get_option('fsrs_pr_option', '0');
        if (empty($is_licensed) || $valid['valid'] == '0') {?>
            <div class="fsrs-activation-container">
                <div class="fsrs-activate-header">
                    <h1 style="color:white; padding: 24px; margin: 0">فعالسازی فول اسکیما</h1>
                </div>
                <div class="not-active">
                    <img src="<?php echo FSRS_ADMIN_URL . 'image/fail.png' ?>" alt="">
                    <h3 style="color: #ff5a6f; margin-bottom: 32px; margin-top: -4px">متاسفانه هنوز افزونه را فعال
                        نکردید!</h3>
                </div>
                <h3 style="margin-bottom: -12px"> کدی که از سایت <a href="https://zhaket.com">ژاکت</a> دریافت کردید را
                    اینجا وارد کنید و روی دکمه‌ی
                    فعال کردن افزونه کلیک کنید.</h3>
                <p>
                    <label for="activation-field" class="fsrs-h4">کد فعالسازی</label>
                    <input id="activation-field" type="text" class="activate-input">
                </p>
                <button class="btn-activation" type="submit" style="display: none">فعال کردن افزونه</button>
                <div class="loader" style="display: none"></div>
                <div class="response-text"></div>
                <input id="fsrs-active-nonce" type="hidden"
                       value="<?php echo wp_create_nonce('fsrs-activation-nonce') ?>">
            </div>
        <?php } else if ($valid['valid'] == '1') {
            include FSRS_ADMIN_DIR . 'template/class-fsrs-is-active.php';
        }
    }

    public function enqueue_scripts()
    {
        ?>
        <script>
            jQuery(document).ready(function ($) {
                setupValidity();
                $('.loader').hide();
                $('#activation-field').on('keydown keyup change', function (e) {
                    setupValidity();
                });

                function setupValidity() {
                    var activationLength = $('#activation-field').val().length;
                    if (activationLength < 1) {
                        $('.btn-activation').hide();
                    } else {
                        $('.btn-activation').show();
                    }
                }
            });
        </script>
        <?php
    }
}