jQuery(document).ready(function ($) {

    $('#fsrs-settings-save').on('click', function (e) {
        e.preventDefault();
        $('.loader1').show();
        var data = {
            action: "fsrs_save_rating_settings",
            nonce: fsrs_object.nonce,
            fsrs_st_up_star_size: $('#fsrs-st-up-star-size').val(),
            fsrs_st_down_star_size: $('#fsrs-st-down-star-size').val(),
            fsrs_st_up_star_show: $('#fsrs-st-up-star-show').val(),
            fsrs_st_down_thanks_text: $('#fsrs-st-down-thanks-text').val(),
            fsrs_st_down_font_size: $('#fsrs-st-down-font-size').val()
        };
        jQuery.ajax({
            type: "POST",
            dataType: "json",
            url: fsrs_object.ajax_url,
            data: data,
            success: function (response) {
                $('.loader1').hide();
                if (response.code == '110') {
                    $('.save_setting_response').addClass('fsrs-success');
                    $('.save_setting_response').show();
                    $('.save_setting_response').text("تنظیمات با موفقیت ذخیره شد.");
                    setTimeout(hideResponse, 3000);

                    function hideResponse() {
                        $('.save_setting_response').hide();
                    }
                }
            }, error: function (error) {
                $('.loader1').hide();
                console.log(error);
            }
        });
    });

    $('#fsrs_save_star_texts').on('click', function (e) {
        e.preventDefault();
        $('.loader2').show();
        var data = {
            action: "fsrs_save_star_texts",
            nonce: fsrs_object.nonce,
            fsrs_star1: $('#fsrs-first-rating').val(),
            fsrs_star2: $('#fsrs-second-rating').val(),
            fsrs_star3: $('#fsrs-third-rating').val(),
            fsrs_star4: $('#fsrs-four-rating').val(),
            fsrs_star5: $('#fsrs-five-rating').val()
        };
        jQuery.ajax({
            type: "POST",
            dataType: "json",
            url: fsrs_object.ajax_url,
            data: data,
            success: function (response) {
                $('.loader2').hide();
                if (response.code == '110') {
                    $('.save_star_text_response').addClass('fsrs-success');
                    $('.save_star_text_response').show();
                    $('.save_star_text_response').text("تنظیمات با موفقیت ذخیره شد.");
                    setTimeout(hideResponse, 3000);

                    function hideResponse() {
                        $('.save_star_text_response').hide();
                    }
                }
            }, error: function (error) {
                $('.loader2').hide();
                console.log(error);
            }
        });
    });

    $('#fsrs-notif-is-seen').on('click', function (e) {
        if ($('#notif-size').val() > 0) {
            $('#fsrs-notif-is-seen').removeClass('dashicons-visibility');
            $('#fsrs-notif-is-seen').addClass('dashicons-hidden');
            var data = {
                action: "fsrs_set_notif_read",
                nonce: fsrs_object.nonce,
                content: $('#notif-body').val(),
            };
            jQuery.ajax({
                type: "POST",
                dataType: "json",
                url: fsrs_object.ajax_url,
                data: data,
                success: function (response) {
                    if (response.code == '110') {
                        $('#fsrs-notif-is-seen').removeClass('dashicons-visibility');
                        $('#fsrs-notif-is-seen').addClass('dashicons-hidden');
                    }
                }, error: function (error) {
                    console.log(error);
                }
            });
        }
    });

    $('.btn-activation').on('click', function (e) {
        $('.btn-activation').hide();
        $('.loader').show();
        var data = {
            action: "fsrs_activate",
            nonce: $('#fsrs-active-nonce').val(),
            licenseKey: $('#activation-field').val(),
        };
        jQuery.ajax({
            type: "POST",
            dataType: "json",
            url: fsrs_object.ajax_url,
            data: data,
            success: function (response) {
                console.log(response);
                if (response.result == '0') {
                    $('.btn-activation').show();
                    $('.loader').hide();
                    $('.response-text').addClass('fsrs-error');
                    $('.response-text').text("لایسنس شما نامعتبر است. لطفا لایسنس معتبر وارد کنید!");
                }
                if (response.result == '1') {
                    $('.loader').hide();
                    $('.response-text').addClass('fsrs-success');
                    $('.response-text').text("تبریک! لایسنس شما با موفقیت فعال شد.");
                    location.reload();
                }
            }, error: function (error) {
                $('.btn-activation').show();
                $('.loader').hide();
                console.log(error);
            }
        });

    });
});