<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class FSRS_ADMIN {

	public static $instance = null;

	/**
	 * Instance.
	 *
	 * @return FSRS_ADMIN An instance of the class.
	 * @access public
	 * @static
	 *
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function __construct() {
		require_once FSRS_ADMIN_DIR . 'template/class-schema-metabox.php';
		require_once FSRS_ADMIN_DIR . 'template/class-fsrs-admin-setting.php';
		new FSRS_METABOX();
		new FSRS_ADMIN_SETTING();
		add_action( 'wp_enqueue_scripts', [ $this, 'frontend_assets' ] );
		$this->check_validity();
	}



	/**
	 * Add FAQ schema in header
	 *
	 * @return void
	 */
	public static function printFAQSchema() {
		$faqs = get_post_meta( get_the_ID(), '_fsrs_faq_schema', true );
		if ( ! is_singular() && ! is_tax() && ! is_category() && ! is_tag() ) {
			return;
		}
		if ( is_tax() || is_category() || is_tag() ) {
			$term = get_queried_object();
			$faqs = get_term_meta( $term->term_id, '_fsrs_faq_schema', true );
		}
		if ( empty( $faqs ) ) {
			return;
		}

		$schema_array = [
			'@context'   => 'https://schema.org',
			'@type'      => 'FAQPage',
			'mainEntity' => [],
		];

		if ( ! empty( $faqs ) ) {
			foreach ( $faqs as $faq ) {
				$schema_array['mainEntity'][] = [
					'@type'          => 'Question',
					'name'           => $faq['q'],
					'acceptedAnswer' => [
						'@type' => 'Answer',
						'text'  => $faq['a'],
					],
				];
			}
		}
		?>
        <script type="application/ld+json">
			<?php echo wp_json_encode( $schema_array ); ?>



        </script>
		<?php
	}

	/**
	 * Add rating schema in header
	 *
	 * @return void
	 */
	public static function printRatingSchema() {
		$rating  = get_post_meta( get_the_ID(), '_fsrs_schema', true );
		$post_id = get_the_ID();
		global $wpdb;
		$sql          = "SELECT avg(meta_value) AS rating, count(meta_value) 'count'
                    FROM {$wpdb->prefix}postmeta WHERE  meta_key = '_fsrs_rating' 
                    AND post_id = '$post_id'";
		$rate_res     = $wpdb->get_results( $sql, 'ARRAY_A' );
		$rating_value = '5';
		$seen_count   = '1';
		foreach ( $rate_res as $row ) {
			$rating_value = strval( round( $row['rating'], 1, PHP_ROUND_HALF_UP ) );
			if ( $rating_value == '0' ) {
				$rating_value = '5';
			}
			$seen_count = strval( $row['count'] );
			if ( $seen_count == '0' ) {
				$seen_count = '1';
				add_post_meta( $post_id, '_fsrs_rating', 5 );
			}
		}
		$aggregateRating = array(
			'@type'       => 'AggregateRating',
			'ratingValue' => $rating_value,
			'bestRating'  => '5',
			'ratingCount' => $seen_count,
			'worstRating' => '1'
		);
		if ( empty( $rating ) ) {
			$rating = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::default_options( $post_id, get_the_title( $post_id ),
				$aggregateRating
			);
		} else {
			$post_options = get_post_meta( get_the_ID(), '_fsrs_schema', true );
			$schema_type  = $post_options['@type'];
			$title        = $post_options['name'];
			$desc         = $post_options['description'];
			$duration     = $post_options['duration'];
			$content_url  = $post_options['contentUrl'];

			if ( $schema_type == 'VideoObject' ) {
				$rating = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::video_object_options( get_the_ID(), $title, $desc, $duration,
					$content_url, $aggregateRating );
			} else if ( $schema_type == 'AudioObject' ) {
				$rating = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::audio_object_options( $duration, $title, $desc, $content_url,
					$aggregateRating );
			} else if ( $schema_type == 'MediaObject' ) {
				$rating = FULL_SCHEMA_RICH_SNIPPET_SETTINGS::default_options( $post_id, get_the_title( $post_id ),
					$aggregateRating
				);
			}
		}
		if ( is_singular( 'post' ) ) {
			?>
            <script type="application/ld+json">
				<?php echo wp_json_encode( $rating ) ?>



            </script>
			<?php
		}

		if ( is_singular( 'page' ) ) {
			$result = get_post_meta( get_the_ID(), '_fsrs_page_star_option', true );
			if ( ! empty( $result ) && $result['showOption'] == '1' ) {
				?>
                <script type="application/ld+json">
				<?php echo wp_json_encode( $rating ) ?>



                </script>
				<?php
			}
		}
	}

	/**
	 * Add user custom script or css ... in header
	 *
	 * @return void
	 */
	public static function addHeaderScript() {
		$fsrs_script = get_post_meta( get_the_ID(), '_fsrs_script', true );
		echo ! isset( $fsrs_script['header'] ) ? '' : $fsrs_script['header'];
	}

	/**
	 * enqueue css and scripts
	 */
	public function frontend_assets() {
		wp_enqueue_style( 'fsrs-faq-schema-jquery-ui',
			FSRS_ADMIN_URL . '/css/jquery-ui.css', [], '2.0.0' );
		wp_enqueue_script( 'fsrs-faq-schema-frontend',
			FSRS_ADMIN_URL . '/js/frontend.js', [ 'jquery', 'jquery-ui-accordion' ],
			'2.0.0', true );
	}

	/**
	 * check validity license
	 *
	 * @return void
	 */
	private function check_validity() {
		add_action( 'admin_notices', 'sample_admin_notice__success' );
		function sample_admin_notice__success() {
			$validity = get_option( 'fsrs-pr-license', '' );
			if ( empty( $validity ) ) { ?>
                <div class="notice notice-error">
                    <p style="font-size: 16px;">
                        هنوز فول اسکیما را فعال نکردید! لطفا برای استفاده از امکانات افزونه آن را فعال سازی کنید.
                    </p>
                    <p style="font-size: 16px;">
                        <a href="<?php echo admin_url() . 'admin.php?page=fsrs-activation' ?>">
                            <button class="button-primary">فعال کردن افزونه</button>
                        </a>
                    </p>
                </div>
			<?php }
		}
	}
}

FSRS_ADMIN::instance();
